<?php

namespace App\Jobs;

use App\Imports\ImportDapodikGuru;
use App\Libraries\ShouldQueue\ImportTransaksi;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;

class ImportDataJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $data;

    /**
     * Create a new job instance.
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        Log::info("intip data", ['tes' => $this->data]);

        if($this->data['jenis'] == 'importGuru'){
            $function = $this->data['jenis'];
            ImportTransaksi::$function($this->data);
        }

        if($this->data['jenis'] == 'importGuruSplit'){
            $function = $this->data['jenis'];
            ImportTransaksi::$function($this->data);
        }

        if($this->data['jenis'] == 'importSiswa'){
            $function = $this->data['jenis'];
            ImportTransaksi::$function($this->data);
        }

        if($this->data['jenis'] == 'importSiswaSplit'){
            $function = $this->data['jenis'];
            ImportTransaksi::$function($this->data);
        }

        if($this->data['jenis'] == 'migrasiSiswa'){
            $function = $this->data['jenis'];
            ImportTransaksi::$function($this->data);
        }

        if($this->data['jenis'] == 'migrasiDapodikSiswa'){
            $function = $this->data['jenis'];
            ImportTransaksi::$function($this->data);
        }

        if($this->data['jenis'] == 'migrasiDapodikSiswaSplit'){
            $function = $this->data['jenis'];
            ImportTransaksi::$function($this->data);
        }

        if($this->data['jenis'] == 'migrasiGuru'){
            $function = $this->data['jenis'];
            ImportTransaksi::$function($this->data);
        }

        if($this->data['jenis'] == 'migrasiDapodikGuru'){
            $function = $this->data['jenis'];
            ImportTransaksi::$function($this->data);
        }

        if($this->data['jenis'] == 'migrasiDapodikGuruSplit'){
            $function = $this->data['jenis'];
            ImportTransaksi::$function($this->data);
        }
    }
}
