<?php

namespace App\Imports;

use App\Jobs\ImportDataJob;
use Illuminate\Support\Facades\DB;
use App\Models\ImportDapodik\ImportDapodikSiswaModel;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ImportDapodikSiswa implements ToCollection, WithHeadingRow
{

    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    // Skip rows before the actual table (adjust as needed)
    public function headingRow(): int
    {
        return 5; // Start reading from the second row (which contains the merged cells)
    }

    /**
     * @param Collection $rows
     */
    public function collection(Collection $rows)
    {
        $rows->shift();
        foreach ($rows as $row) {
            $row['jenis']         = 'importSiswaSplit';
            $row['idUser']        = $this->data['idUser'];
            $row['idPSekolah']    = $this->data['idPSekolah'];
            $row['idPPeriode']    = $this->data['idPPeriode'];
            $row['idPKKode']      = $this->data['idPKKode'];
            $row['idMStatus']     = $this->data['idMStatus'];
            $row['idPPKelas']     = $this->data['idPPKelas'];
            $row['idPPStatus']    = $this->data['idPPStatus'];

            ImportDataJob::dispatch($row);
        }

        // DB::beginTransaction();
        // try {
        //     foreach ($rows as $row) {
        //         ImportDapodikSiswaModel::create([
        //             'nama' => $row['nama'],
        //             'nipd' => $row['nipd'],
        //             'jk' => $row['jk'],
        //             'nisn' => $row['nisn'],
        //             'tempat_lahir' => $row['tempat_lahir'],
        //             'tanggal_lahir' => $row['tanggal_lahir'],
        //             'nik' => $row['nik'],
        //             'agama' => $row['agama'],
        //             'alamat' => $row['alamat'],
        //             'rt' => $row['rt'],
        //             'rw' => $row['rw'],
        //             'dusun' => $row['dusun'],
        //             'kelurahan' => $row['kelurahan'],
        //             'kecamatan' => $row['kecamatan'],
        //             'kode_pos' => $row['kode_pos'],
        //             'jenis_tinggal' => $row['jenis_tinggal'],
        //             'alat_transportasi' => $row['alat_transportasi'],
        //             'telepon' => $row['telepon'],
        //             'hp' => $row['hp'],
        //             'email' => $row['e_mail'],
        //             'skhun' => $row['skhun'],
        //             'penerima_kps' => $row['penerima_kps'],
        //             'no_kps' => $row['no_kps'],

        //             // Data Ayah
        //             'nama_ayah' => $row['data_ayah'],
        //             'tahun_lahir_ayah' => $row[25],
        //             'jenjang_pendidikan_ayah' => $row[26],
        //             'pekerjaan_ayah' => $row[27],
        //             'penghasilan_ayah' => $row[28],
        //             'nik_ayah' => $row[29],

        //             // Data Ibu
        //             'nama_ibu' => $row['data_ibu'],
        //             'tahun_lahir_ibu' => $row[31],
        //             'jenjang_pendidikan_ibu' => $row[32],
        //             'pekerjaan_ibu' => $row[33],
        //             'penghasilan_ibu' => $row[34],
        //             'nik_ibu' => $row[35],

        //             // Data Wali
        //             'nama_wali' => $row['data_wali'],
        //             'tahun_lahir_wali' => $row[37],
        //             'jenjang_pendidikan_wali' => $row[38],
        //             'pekerjaan_wali' => $row[39],
        //             'penghasilan_wali' => $row[40],
        //             'nik_wali' => $row[41],

        //             'rombel_saat_ini' => $row['rombel_saat_ini'],
        //             'no_peserta_un' => $row['no_peserta_ujian_nasional'],
        //             'no_seri_ijazah' => $row['no_seri_ijazah'],
        //             'penerima_kip' => $row['penerima_kip'],
        //             'nomor_kip' => $row['nomor_kip'],
        //             'nama_di_kip' => $row['nama_di_kip'],
        //             'nomor_kks' => $row['nomor_kks'],
        //             'no_registrasi_akta_lahir' => $row['no_registrasi_akta_lahir'],
        //             'bank' => $row['bank'],
        //             'nomor_rekening_bank' => $row['nomor_rekening_bank'],
        //             'rekening_atas_nama' => $row['rekening_atas_nama'],
        //             'layak_pip' => $row['layak_pip_usulan_dari_sekolah'],
        //             'alasan_layak_pip' => $row['alasan_layak_pip'],
        //             'kebutuhan_khusus' => $row['kebutuhan_khusus'],
        //             'sekolah_asal' => $row['sekolah_asal'],
        //             'anak_keberapa' => $row['anak_ke_berapa'],
        //             'lintang' => $row['lintang'],
        //             'bujur' => $row['bujur'],
        //             'no_kk' => $row['no_kk'],
        //             'berat_badan' => $row['berat_badan'],
        //             'tinggi_badan' => $row['tinggi_badan'],
        //             'lingkar_kepala' => $row['lingkar_kepala'],
        //             'jml_saudara_kandung' => $row['jml_saudara_kandung'],
        //             'jarak_rumah_ke_sekolah_km' => $row['jarak_rumah_ke_sekolah_km']
        //         ]);
        //     }
        //     DB::commit();
        // } catch (\Exception $e) {
        //     // Rollback the transaction
        //     DB::rollBack();
        //     // Handle the exception and return a response
        //     throw $e;
        // }
    }
}
