<?php

namespace App\Imports;

use App\Jobs\ImportDataJob;
use App\Models\ImportDapodik\ImportDapodikGuruModel;
use App\Models\ImportDapodik\ImportDapodikGuruTempModel;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ImportDapodikGuru implements ToCollection, WithHeadingRow
{
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    // Skip rows before the actual table (adjust as needed)
    public function headingRow(): int
    {
        return 5; // Start reading from the second row (which contains the merged cells)
    }

    /**
     * @param Collection $rows
     */
    public function collection(Collection $rows)
    {
        
        foreach ($rows as $row) {

            if (!empty($row['nip'])) {
                $row['jenis']         = 'importGuruSplit';
                $row['idUser']        = $this->data['idUser'];
                $row['idPSekolah']    = $this->data['idPSekolah'];
                $row['idPPeriode']    = $this->data['idPPeriode'];
                // $row['idPPStatus']    = $this->data['idPPStatus'];

                // Dispatch job untuk memproses row
                ImportDataJob::dispatch($row);
            }

            // $row['jenis']         = 'importGuruSplit';
            // $row['idUser']        = $this->data['idUser'];
            // $row['idPSekolah']    = $this->data['idPSekolah'];
            // $row['idPPeriode']    = $this->data['idPPeriode'];
            // $row['idPKKode']      = $this->data['idPKKode'];
            // $row['idMStatus']     = $this->data['idMStatus'];
            // $row['idPPKelas']     = $this->data['idPPKelas'];
            // $row['idPPStatus']    = $this->data['idPPStatus'];

            // $row['idPPStatus']    = $this->data['idPPStatus'];

            // ImportDataJob::dispatch($row);
        }
    }
}
