<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\JurusanModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
// use App\Models\MSiswaModel;
// use App\Models\MGuruModel;

class TabelPerpusController extends Controller
{
    private $url        = 'admin/master/sekolah';

public function __construct()
    {
        createLogActivity();
        $this->mPerpusSekolah         = new SekolahModel();
        $this->mPerpusJurusan         = new JurusanModel();
        $this->mPerpusKelas           = new KelasModel();
        $this->mPerpusKelasKode       = new KelasKodeModel();
        // $this->mSiswa               = new MSiswaModel();
        // $this->mGuru               = new MGuruModel();
    }

    function getSekolahDaerah($idMDaerah = null){
        if(session()->get('role') == 1){
            $perpus_sekolah = $this->mPerpusSekolah->where('idMDaerah', $idMDaerah)->get();
        }else{
            $perpus_sekolah = [];
        }

        $i = 1;
        foreach ($perpus_sekolah as $row)
        {

            $btnDetail = "<a href='".url($this->url."/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail</button></a>";
            $btnEdit = "<a href='".url($this->url."/".$row->id)."/edit"."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Edit</button></a>";
            $btn = $btnDetail.' '.$btnEdit;

            $tbody      = [];
            $tbody[]    = $i++; 
            $tbody[]    = $row->daerah->nama;
            $tbody[]    = $row->npsn;
            $tbody[]    = $row->nama;
            $tbody[]    = $row->alamat;
            $tbody[]    = $btn;

            $data[]     = $tbody;
        }

        // if ($siswa != null)
        if (count($perpus_sekolah) > 0)
        {
            $response = [
                'data'      => $data,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'data'      => '',
            ];
            echo json_encode($response);
        }
    }

    function getSekolahJurusan($idPSekolah = null){
        
        if(session()->get('role') == 1){
            $jurusan = $this->mPerpusJurusan->where('idPSekolah', $idPSekolah)->get();
        }else{
            $jurusan = $this->mPerpusJurusan->where('idPSekolah', session()->get('idPSekolah'))->get();
        }

        $i = 1;
        foreach ($jurusan as $row)
        {

            $btnDetail = "<a href='".url($this->url."/jurusan/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail</button></a>";
            $btnEdit = "<a href='".url($this->url."/jurusan/".$row->id)."/edit"."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Edit</button></a>";
            $btn = $btnDetail.' '.$btnEdit;

            $tbody      = [];
            $tbody[]    = $i++; 
            
            if (session()->get('role') == 1)
            $tbody[]    = $row->sekolah->nama;

            $tbody[]    = $row->nama;
            $tbody[]    = $btn;

            $data[]     = $tbody;
        }

        // if ($siswa != null)
        if (count($jurusan) > 0)
        {
            $response = [
                'data'      => $data,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'data'      => '',
            ];
            echo json_encode($response);
        }
    }

    function getSekolahKelas($idPJurusan = null)
    {    
        if(session()->get('role') == 1){
            $kelas = $this->mPerpusKelas->where('idPJurusan', $idPJurusan)->get();
        }else{
            $kelas = $this->mPerpusKelas->where('idPJurusan', $idPJurusan)->where('idPSekolah', session()->get('idPSekolah'))->get();
        }

        $i = 1;
        foreach ($kelas as $row)
        {

            $btnDetail = "<a href='".url($this->url."/tingkat/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail</button></a>";
            $btnEdit = "<a href='".url($this->url."/tingkat/".$row->id)."/edit"."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Edit</button></a>";
            $btn = $btnDetail.' '.$btnEdit;

            $tbody      = [];
            $tbody[]    = $i++;

            if (session()->get('role') == 1)
            $tbody[]    = $row->sekolah->nama;

            $tbody[]    = $row->jurusan->nama;
            $tbody[]    = $row->nama;
            $tbody[]    = $btn;

            $data[]     = $tbody;
        }

        // if ($siswa != null)
        if (count($kelas) > 0)
        {
            $response = [
                'data'      => $data,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'data'      => '',
            ];
            echo json_encode($response);
        }
    }

    function getSekolahKelasKode($idPKelas = null)
    {
        if(session()->get('role') == 1){
            $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idPKelas)->get();
        }else{
            $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idPKelas)->where('idPSekolah', session()->get('idPSekolah'))->get();
        }    

        $i = 1;
        foreach ($kelaskode as $row)
        {

            $btnDetail = "<a href='".url($this->url."/indeks-kelas/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail</button></a>";
            // $btnDetail = "<a href='".url($this->url."/indeks-kelas/dapodik/".$row->id)."'><button type='button' class='btn btn-warning btn-sm' title='Detail Data'>Detail</button></a>";
            $btnEdit = "<a href='".url($this->url."/indeks-kelas/".$row->id)."/edit"."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Edit</button></a>";
            $btn = $btnDetail.' '.$btnEdit;

            $tbody      = [];
            $tbody[]    = $i++; 
            
            if (session()->get('role') == 1)
            $tbody[]    = $row->sekolah->nama;

            $tbody[]    = $row->kelas->nama.' '.$row->kelas->jurusan->nama.' '.$row->nama;
            // $tbody[]    = count($row->jmlSiswa);
            $tbody[]    = $btn;

            $data[]     = $tbody;
        }

        // if ($siswa != null)
        if (count($kelaskode) > 0)
        {
            $response = [
                'data'      => $data,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'data'      => '',
            ];
            echo json_encode($response);
        }
    }

    function getSekolahGuru($idPSekolah = null)
    {    
        if(session()->get('role') == 1){
            $guru      = $this->mGuru->where('idPSekolah', $idPSekolah)->get();
        }else{
            $guru      = $this->mGuru->where('idPSekolah', session()->get('idPSekolah'))->get();
        }

        $i = 1;
        foreach ($guru as $row)
        {

            $btnDetail = "<a href='".url($this->url."/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail</button></a>";
            $btnEdit = "<a href='".url($this->url."/".$row->id)."/edit"."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Edit</button></a>";
            $btn = $btnDetail.' '.$btnEdit;

            $tbody      = [];
            $tbody[]    = $i++; 
            $tbody[]    = $row->sekolah->nama;
            $tbody[]    = $row->nip;
            $tbody[]    = $row->nama;
            if ($row->status == 1) {
                $tbody[] = 'Aktif';
            } else if ($row->status == 0){
                $tbody[] = 'Non Aktif';
            }
            $tbody[]    = $btn;

            $data[]     = $tbody;
        }

        // if ($siswa != null)
        if (count($guru) > 0)
        {
            $response = [
                'data'      => $data,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'data'      => '',
            ];
            echo json_encode($response);
        }
    }

}
