<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Perpus\KelasKodeModel;

use App\Models\Siswa\SiswaModel;
use App\Models\Stakeholder\KonselorModel;

class SiswaController extends Controller
{
public function __construct()
    {
        createLogActivity();
        $this->mPerpusKelasKode       = new KelasKodeModel();
        
        $this->mSiswa           = new SiswaModel();
        $this->mKonselor        = new KonselorModel();
        
    }

    public function getSiswaKelas($idPKKode = null)
    {
        // kayanya yang pake ini cuma layanan
        if(session()->get('role') == 1){
            $whereSiswa = [
                'idPKKode'          => $idPKKode,
                'idMStatus'         => 1,
                'idPPkelas'         => 1,
                'idPPStatus'        => 1,
            ];
            $siswa = $this->mSiswa->where($whereSiswa)->get()->toArray();
        }else if(session()->get('role') == 2){
            $kelaskode = $this->mPerpusKelasKode->where('idPSekolah', session()->get('idPSekolah'))->where('id', $idPKKode)->get('id')->toArray();

            $whereSiswa = [
                'idPSekolah'        => session()->get('idPSekolah'),
                'idPPeriode'        => session()->get('idPPeriode'),
                'idPKKode'          => $kelaskode,
                'idMStatus'         => 1,
                'idPPkelas'         => 1,
                'idPPStatus'        => 1,
            ];
            $siswa = $this->mSiswa->where($whereSiswa)->get()->toArray();
        }
        
        else if(session()->get('role') == 3){
            $kelaskode = $this->mPerpusKelasKode->where('idPSekolah', session()->get('idPSekolah'))->where('id', $idPKKode)->get('id')->toArray();
            
            $whereSiswa = [
                'idPSekolah'        => session()->get('idPSekolah'),
                'idPPeriode'        => session()->get('idPPeriode'),
                'idPKKode'          => $kelaskode,
                'idSKonselor'       => session()->get('idSKonselor'),
                'idMStatus'         => 1,
                'idPPkelas'         => 1,
                'idPPStatus'        => 1,
            ];
            $siswa = $this->mSiswa->where($whereSiswa)->get()->toArray();

        }

        $dataAnyar = array_map(function($kk) {
            return [
                'id'       => $kk['id'],
                'nama'     => $kk['nisn'].' - '.$kk['nama'],
            ];
        }, $siswa);

        $data = [
            'error_code'    => 0,
            'data'          => $dataAnyar,
        ];

        echo json_encode($data);
    }

    public function getSiswaKonselorKelas($idPKKode = null)
    {

        // $konselor = $this->mKonselor->where('idSGuru', session()->get('idSKonselor'))->first();
        
        $whereSiswa = [
            'idPSekolah'        => session()->get('idPSekolah'),
            'idPPeriode'        => session()->get('idPPeriode'),
            'idPKKode'          => $idPKKode,
            'idSKonselor'       => session()->get('idSKonselor'),
            // 'idSKonselor'       => $konselor->id,
            'idMStatus'         => 1,
            'idPPkelas'         => 1,
            'idPPStatus'        => 1,
        ];
        $siswa = $this->mSiswa->where($whereSiswa)->get()->toArray();
        
        $data = array_map(function($kk) {
            return [
                'id'       => $kk['id'],
                'nama'     => $kk['nisn'].' - '.$kk['nama'],
                'idSKonselor'       => $kk['idSKonselor'],
            ];
        }, $siswa);

        $data = [
            'error_code'    => 0,
            'data'          => $data,
        ];
        echo json_encode($data);
    }

    // public function getSiswaKonselor()
    // {
    //     $siswa = $this->mSiswa->where('idSKonselor', session()->get('idSKonselor'))->get()->toArray();
    //     // xi ipa 1. angkatan jurusan kelas
    //     $data = array_map(function($kk) {
    //         return [
    //             'idSiswa'       => $kk['id'],
    //             'nama'          => $kk['idPKKode']->kelaskode->nama.' '.$kk['nama'],
    //         ];
    //     }, $siswa);

    //     $data = [
    //         'error_code'    => 0,
    //         'data'          => $data,
    //     ];
    //     echo json_encode($data);
    // }

    public function getSiswaKonselor()
    {
        $kelaskode = $this->mPerpusKelasKode->where('idPSekolah', session()->get('idPSekolah'))->get('id')->toArray();
        
        $whereSiswa = [
            'idPSekolah'        => session()->get('idPSekolah'),
            'idPPeriode'        => session()->get('idPPeriode'),
            'idSKonselor'       => session()->get('idSKonselor'),
            'idMStatus'         => 1,
            'idPPkelas'         => 1,
            'idPPStatus'        => 1,
        ];
        $siswa = $this->mSiswa->with('kelaskode')->whereIn('idPKKode', $kelaskode)->where($whereSiswa)->get()->toArray();
        
        $data = array_map(function($kk) {
            return [
                'idSiswa'       => $kk['id'],
                'nama'          => $kk['kelaskode']['nama'].' '.$kk['nama'],
            ];
        }, $siswa);

        $data = [
            'error_code'    => 0,
            'data'          => $data,
        ];
        echo json_encode($data);
    }

}