<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

use App\Models\User\UserModel;
use App\Models\Master\ProvinsiModel;
use App\Models\Master\PeriodeModel;
use App\Models\Perpus\SekolahModel;

class UsersController extends Controller
{
    private $views      = 'admin/users';
    private $url        = 'admin/users';
    private $title      = 'Halaman Users';

public function __construct()
    {
        createLogActivity();
        $this->mUsers           = new UserModel();
        $this->mPerpusSekolah   = new SekolahModel();
        $this->mProvinsi        = new ProvinsiModel();
        $this->mPeriode         = new PeriodeModel();

    }

    public function index()
    {
        $users = $this->mUsers->where('role', 2)->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data User',
            'users'         => $users,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $provinsi = $this->mProvinsi->get();
        $periode = $this->mPeriode->get();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Users',
            'provinsi'      => $provinsi,
            'periode'       => $periode,
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $sekolah = $this->mPerpusSekolah->where('id', $request->idPSekolah)->first();
        $periode = $sekolah->idPPeriode;

        $users = $this->mUsers->where('username', $sekolah->npsn)->first();
        if ($users) {
            return redirect("$this->url")->with('gagal', 'Sekolah sudah punya akun admin');
        }

        $dataUser = [
            'username'          => $sekolah->npsn,
            'password'          => Hash::make($request->password),
            'sandi'             => $request->password,
            'status'            => $request->status,
            'idPSekolah'        => $request->idPSekolah,
            'role'              => 2,
            'idPPeriode'        => $sekolah->idPPeriode,
        ];
        $this->mUsers->create($dataUser);

        return redirect("$this->url")->with('sukses', 'User berhasil di tambahkan');
    }

    public function show($id)
    {
        // Get Data
    }

    public function edit($id)
    {
        // Get Data
        $user = $this->mUsers->where('id', $id)->first();
        // echo json_encode($user); die;
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Edit Data Users',
            'id'            => $id,
            'user'          => $user,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
       
        if ($request->password != $request->verifikasi) {
            return redirect("$this->url/$id/edit")->with('gagal', 'Verifikasi password harus sama dengan password');
        } else {
            $dataUser = [
                'password'      => Hash::make($request->password),
                'sandi'         => $request->password,
            ];
            $this->mUsers->where('id', $id)->update($dataUser);
            return redirect("$this->url")->with('sukses', 'Data Pengguna berhasil di edit');
        }
    }

    public function destroy($id)
    {
        //
    }
}
