<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Stakeholder;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use DB;
use App\Models\Stakeholder\WakaKesiswaanModel;
use App\Models\Stakeholder\GuruModel;

class WakaKesiswaanController extends Controller
{
    private $views      = 'admin/stakeholder/waka_kesiswaan';
    private $url        = 'admin/guru/waka-kesiswaan';
    private $title      = 'Halaman Waka Kesiswaan';

public function __construct()
    {
        createLogActivity();
        $this->mWakaKesiswaan     = new WakaKesiswaanModel();
        $this->mGuru         = new GuruModel();
    
    }

    public function index()
    {
        $where = [
            'status' => 1,
            'idPSekolah'=> session()->get('idPSekolah'),
        ];
        $wakaKesiswaan = $this->mWakaKesiswaan->where($where)->first();
        if(isset($wakaKesiswaan)){
            $guru = $this->mGuru->where('id', $wakaKesiswaan['idSGuru'])->get(); // tampilkan data guru sebagai kepsek
        }else{
            $guru = null;
        }
        // contoh where. get() ambil semua, first() ambil baris pertama. jadi nanti di index langsung $user->nama untuk panggil kolom nama
        // $user = $this->mUser->where('id', $id)->first();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Waka Kesiswaan',
            'guru'         => $guru,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $where = [
            'status' => 1,
            'idPSekolah'=> session()->get('idPSekolah'),
        ];
        $wakaKesiswaan = $this->mWakaKesiswaan->where($where)->first();

        if(isset($wakaKesiswaan)){

            $guru = $this->mGuru->where($where)->whereNot('id', $wakaKesiswaan['idSGuru'])->get();
        }else{
            $guru = $this->mGuru->where($where)->get();
        }

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Waka Kesiswaan',
            'guru'          => $guru,
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $where = [
            'status' => 1,
            'idPSekolah'=> session()->get('idPSekolah'),
        ];
        $dataStatus = [
            'status'    => 0 // update semua statusya jadi 0
        ];
        // cari yang statusnya 1, terus semua diupdate jadi 0
        $this->mWakaKesiswaan->where($where)->update($dataStatus);

        // cek ada guru yg sama di tabel kepsek tidak
        $where2 = [
            'idPSekolah'=> session()->get('idPSekolah'),
            'idSGuru' => $request->idSGuru
        ];
        $wakaKesiswaan = $this->mWakaKesiswaan->where($where2)->first();
        if (isset($wakaKesiswaan)){ // kalo ada, update status. bukan tambah data guru di tabel kepsek
            $where1 = [
                'idPSekolah'=> session()->get('idPSekolah'),
                'idSGuru' => $request->idSGuru
            ];
            $dataStatus1 = [
                'status'    => 1 // update status guru tsb di tabel kepsek jadi 1
            ];
            $this->mWakaKesiswaan->where($where1)->update($dataStatus1);
        }else{ // kalo data guru tsb di tabel kepsek tidak ada, baru tambah baru. jadi gag ada nama yg sama di tabel kepsek
            // tambah data sekaligus aktifkan jadi status 1
            $dataWakaKesiswaan = [
                // 'idPSekolah'      => $request->idPSekolah,
                'idPSekolah'    => session()->get('idPSekolah'),
                'idSGuru'      => $request->idSGuru,
                'status'        => 1
            ];
            $this->mWakaKesiswaan->create($dataWakaKesiswaan);
        }

        // dd($kepsek);
        return redirect("$this->url")->with('sukses', 'Waka Kesiswaan Berhasil di Perbarui');
    }

    public function show($id)
    {
        // Get Data
    }

    public function edit($id)
    {
        // Get Data
        // $siswa     = $this->mSiswa->where('id', $id)->first();
        // $kelaskode = $this->mPerpusKelasKode->get();
        // $agama     = $this->mAgama->get();

        // $data = [
        //     'title'         => $this->title,
        //     'url'           => $this->url,
        //     'page'          => 'Edit Data Kepala Sekolah',
        //     'id'            => $id,
        //     'siswa'         => $siswa,
        //     'kelaskode'     => $kelaskode,
        //     'agama'         => $agama,
        // ];
        // return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        // $request->validate([
        //     'id'            => 'required',
        //     'idPKKode'      => 'required',
        //     'idMAgama'      => 'required',
        //     'nisn'          => 'required',
        //     'nama'          => 'required',
        //     'lahir_tanggal' => 'required',
        //     'lahir_tempat'  => 'required',
        // ]);
        
        // $dataSiswa = [
        //     'idPKKode'      => $request->idPKKode,
        //     'idMAgama'      => $request->idMAgama,
        //     'nisn'          => $request->nisn,
        //     'nama'          => $request->nama,
        //     'lahir_tanggal' => $request->lahir_tanggal,
        //     'lahir_tempat'  => $request->lahir_tempat,
        // ];
        // $this->mSiswa->where('id', $request->id)->update($dataSiswa);

        // // Response
        // return redirect("$this->url")->with('sukses', 'Data Kepala Sekolah berhasil di edit');
    }

    public function destroy($id)
    {
        //
    }
}
