<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Stakeholder;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use DB;
use App\Models\Perpus\SekolahModel;
use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\GuruModel;

class KepsekController extends Controller
{
    private $views      = 'admin/stakeholder/kepsek';
    private $url        = 'admin/guru/kepala-sekolah';
    private $title      = 'Halaman Kepala Sekolah';

public function __construct()
    {
        createLogActivity();
        $this->mKepsek         = new KepsekModel();
        $this->mGuru         = new GuruModel();
    }

    public function index()
    {
        $where = [
            'status' => 1,
            'idPSekolah'=> session()->get('idPSekolah'),
        ]; 
        $kepsek = $this->mKepsek->where($where)->first(); // cari kepsek yg statusnya 1
        if(isset($kepsek)){
            $guru = $this->mGuru->where('id', $kepsek['idSGuru'])->first(); // tampilkan data guru sebagai kepsek
        }else{
            $guru = null;
        }
        

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Kepala Sekolah',
            'guru'          => $guru,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $where = [
            'status' => 1,
            'idPSekolah'=> session()->get('idPSekolah'),
        ]; 
        $kepsek = $this->mKepsek->where($where)->first();

        if(isset($kepsek)){

            $guru = $this->mGuru->where($where)->whereNot('id', $kepsek['idSGuru'])->get();
        }else{
            $guru = $this->mGuru->where($where)->get();
        }

        // $guru = DB::table('sekolah_guru')
        //             ->where('status', 1)
        //             ->whereNot('id', $kepsek['id'])
        //             ->get();
        // echo json_encode($guru); die();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Kepala Sekolah',
            // 'sekolah'      => $sekolah,
            'guru'          => $guru,
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {

        // untuk update semua status jadi 0
        $where = [
            'idPSekolah'=> session()->get('idPSekolah'),
            'status'    => 1, // update semua statusya jadi 0
        ];
        $dataStatus = [
            'status'    => 0 // update semua statusya jadi 0
        ];
        // cari yang statusnya 1, terus semua diupdate jadi 0
        $this->mKepsek->where($where)->update($dataStatus);

        // $whereKepse = [
        //     'status'    => 1,
        //     'idPPeriode'    => 1,
        // ];
        // $this->mKepsek->where($whereKepse)->update($dataStatus); //CONTOH WHERE BANYAKKKKK

        // cek ada guru yg sama di tabel kepsek tidak
        $where2 = [
            'idPSekolah'=> session()->get('idPSekolah'),
            'idSGuru' => $request->idSGuru
        ];
        $kepsek = $this->mKepsek->where($where2)->first();
        if (isset($kepsek)){ // kalo ada, update status. bukan tambah data guru di tabel kepsek
            $where1 = [
                'idPSekolah'=> session()->get('idPSekolah'),
                'idSGuru' => $request->idSGuru
            ];
            $dataStatus1 = [
                'status'    => 1 // update status guru tsb di tabel kepsek jadi 1
            ];
            $this->mKepsek->where($where1)->update($dataStatus1);
        }else{ // kalo data guru tsb di tabel kepsek tidak ada, baru tambah baru. jadi gag ada nama yg sama di tabel kepsek
            // tambah data sekaligus aktifkan jadi status 1
            $dataKepsek = [
                // 'idPSekolah'      => $request->idPSekolah,
                'idPSekolah'    => session()->get('idPSekolah'),
                'idSGuru'      => $request->idSGuru,
                'status'        => 1
            ];
            $this->mKepsek->create($dataKepsek);
        }

        // dd($kepsek);
        return redirect("$this->url")->with('sukses', 'Kepala Sekolah Berhasil di Perbarui');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        // Get Data
        $kepsek      = $this->mKepsek->where('id', $id)->first();
        $sekolah     = $this->mPerpusSekolah->get();

        $data = [
            'title'     => $this->title,
            'url'       => $this->url,
            'page'      => 'Edit Data Kepala Sekolah',
            'id'        => $id,
            'kepsek'    => $kepsek,
            'sekolah'   => $sekolah
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        $request->validate([
            'id' => 'required',
            'idPSekolah' => 'required',
            'nip' => 'required',
            'nama' => 'required',
        ]);
        
        $dataKepsek = [
                'idPSekolah'=> $request->idPSekolah,
                'nip'       => $request->nip,
                'nama'      => $request->nama,
            ];
        $this->mKepsek->where('id', $request->id)->update($dataKepsek);

        return redirect("$this->url")->with('sukses', 'Data Kepala Sekolah berhasil di edit');
    }

    public function destroy($id)
    {
        //
    }
}
