<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Siswa;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\MPerpusKelasKodeModel;
use App\Models\MSiswaModel;
use App\Models\MSiswaMutasiModel;

class SiswaMutasiController extends Controller
{
    private $views      = 'admin/siswa_mutasi';
    private $url        = 'admin/siswa_mutasi';
    private $title      = 'Halaman Mutasi Siswa ';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct. Biasanya saya isi untuk Model

        $this->mPerpusKelasKode     = new MPerpusKelasKodeModel();
        $this->mSiswa               = new MSiswaModel();
        $this->mSiswaMutasi         = new MSiswaMutasiModel();
    
    }

    public function index()
    {
        $siswa_mutasi = $this->mSiswaMutasi->get();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Mutasi Siswa',
            'siswa_mutasi'          => $siswa_mutasi,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $kelaskode = $this->mPerpusKelasKode->get();
        $siswa = $this->mSiswa->get();


        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Mutasi Siswa',
            'kelaskode'      => $kelaskode,
            'siswa'      => $siswa,
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {

        $dataSiswaMutasi = [
            'idSiswa'      => $request->idSiswa,
            'idPKKode'      => $request->idPKKode,
        ];
        $this->mSiswaMutasi->create($dataSiswaMutasi);

        return redirect("$this->url")->with('sukses', 'Siswa Mutasi berhasil di tambahkan');
    }
}
