<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Siswa;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Master\AgamaModel;
use App\Models\Master\TempatModel;
use App\Models\Master\PekerjaanModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Stakeholder\SekolahWaliModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Siswa\OrtuModel;
use App\Models\Siswa\SiswaModel;
use App\Models\Siswa\SiswaMutasiModel;

class SiswaController extends Controller
{
    private $views      = 'admin/siswa/siswa';
    private $url        = 'admin/siswa';
    private $urlKelas   = 'admin/master/sekolah/indeks-kelas';
    private $title      = 'Halaman Siswa';

public function __construct()
    {
        createLogActivity();
        $this->mAgama               = new AgamaModel();
        $this->mTempat              = new TempatModel();
        $this->mPekerjaan           = new PekerjaanModel();
        $this->mPerpusKelasKode     = new KelasKodeModel();
        $this->mSekolahWali         = new SekolahWaliModel();
        $this->mKonselor            = new KonselorModel();
        $this->mOrtu                = new OrtuModel();
        $this->mSiswa               = new SiswaModel();
        $this->mSiswaMutasi         = new SiswaMutasiModel();
    }

    public function index()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'urlKelas'      => $this->urlKelas,
            'page'          => 'Data Siswa',
        ];

        return view($this->views . "/index", $data);
    }

    public function create($idKelas = null)
    {
        if(session()->get('role') == 1){
            $kelaskode = $this->mPerpusKelasKode->get();

            $where = [
                'status' => 1,
            ];
            $konselor   = $this->mKonselor->where($where)->get();
        }else if(session()->get('role') == 2){
            $kelaskode = $this->mPerpusKelasKode->where('idPSekolah', session()->get('idPSekolah'))->get();

            $where = [
                'status' => 1,
                'idPSekolah'=> session()->get('idPSekolah'),
            ];
            $konselor   = $this->mKonselor->where($where)->get();
        }
        $agama      = $this->mAgama->get();
        $pekerjaan  = $this->mPekerjaan->get();
        $tempat     = $this->mTempat->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Siswa',
            'kelaskode'     => $kelaskode,
            'agama'         => $agama,
            'pekerjaan'     => $pekerjaan,
            'konselor'      => $konselor,
            'tempat'        => $tempat,
            'idKelas'       => $idKelas
        ];

        return view($this->views . "/create", $data);
    }


    public function store(Request $request)
    {
        $lahirTanggal = $request->lahir_tanggal;  
        $lahirTanggalnew = date("d-m-Y", strtotime($lahirTanggal)); 

        $cekSiswa = $this->mSiswa->where('nisn', $request->nisn)->where('idMStatus', 1)->first();
        if(isset($cekSiswa)){
            return redirect("$this->url")->with('gagal', 'Siswa dengan NISN tersebut sudah terdaftar');
        }

        if(session()->get('role') == 1){
            $dataSiswa = [
                'idPKKode'          => $request->idPKKode,
                'idMAgama'          => $request->idMAgama,
                'idPPeriode'        => session()->get('idPPeriode'),
                'idMStatus'         => '1', // Langsung Aktif
                'idSKonselor'       => $request->idSKonselor,
                'nisn'              => $request->nisn,
                'nama'              => $request->nama,
                'lahir_tanggal'     => $lahirTanggalnew,
                'lahir_tempat'      => $request->lahir_tempat,
                'idPPKelas'         => '1', // Langsung Sesuai Periode Sekarang
                'idPPStatus'        => '1', // Langsung Sesuai Periode Sekarang
                'idMTempat'         => $request->idMTempat,
                'email'             => $request->email,
                'telp'              => $request->telp,
                'idPSekolah'        => $request->idPSekolah,
            ];
            $siswa = $this->mSiswa->create($dataSiswa);

            $dataOrtu = [
                'idSiswa'           => $siswa['id'], // dapatkan id Siswa yang baru di input
                'idMPekerjaan'      => $request->idMPekerjaan,
                'nama'              => $request->namaOrtu,
                'alamat'            => $request->alamatOrtu,
                'idPSekolah'        => $request->idPSekolah,
            ];
            $this->mOrtu->create($dataOrtu);

        }else if(session()->get('role') == 2){
            $dataSiswa = [
                'idPKKode'          => $request->idPKKode,
                'idMAgama'          => $request->idMAgama,
                'idPPeriode'        => session()->get('idPPeriode'),
                'idMStatus'         => '1', // Langsung Aktif
                'idSKonselor'       => $request->idSKonselor,
                'nisn'              => $request->nisn,
                'nama'              => $request->nama,
                'lahir_tanggal'     => $lahirTanggalnew,
                'lahir_tempat'      => $request->lahir_tempat,
                'idPPKelas'         => '1', // Langsung Sesuai Periode Sekarang
                'idPPStatus'        => '1', // Langsung Sesuai Periode Sekarang
                'idMTempat'         => $request->idMTempat,
                'email'             => $request->email,
                'telp'              => $request->telp,
                'idPSekolah'        => session()->get('idPSekolah')
            ];
            $siswa = $this->mSiswa->create($dataSiswa);

            $dataOrtu = [
                'idSiswa'           => $siswa['id'], // dapatkan id Siswa yang baru di input
                'idPSekolah'        => session()->get('idPSekolah'),
                'idMPekerjaan'      => $request->idMPekerjaan,
                'nama'              => $request->namaOrtu,
                'alamat'            => $request->alamatOrtu,
            ];
            $this->mOrtu->create($dataOrtu);
        }

        // Riwayat kelas siswa
        $dataSiswaMutasi = [
            'idSiswa'          => $siswa['id'], // dapatkan id Siswa yang baru di input
            'idPKKode'         => $request->idPKKode,
            'idPPeriode'       => session()->get('idPPeriode'),
            'idMStatus'         => '1',
        ];
        $this->mSiswaMutasi->create($dataSiswaMutasi);


        return redirect("$this->url")->with('sukses', 'Siswa berhasil di tambahkan');
    }

    public function show($id)
    {
        $siswa          = $this->mSiswa->where('id', $id)->first();
        $konselor       = $this->mKonselor->where('id', $siswa['idSKonselor'])->first();
        $sekolah_wali   = $this->mSekolahWali->where('idPKKode', $siswa['idPKKode'])->first();
        $ortu           = $this->mOrtu->where('idSiswa', $id)->first();
        $siswaMutasi    = $this->mSiswaMutasi->where('idSiswa', $id)->get();

        // if (!$siswa || !$konselor || !$sekolah_wali || !$ortu || !$siswaMutasi) {
        //     return redirect()->back()->with('gagal', 'Data tidak ditemukan atau sudah dihapus.');
        // }

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Detail Data Siswa',
            'id'            => $id,
            'siswa'         => $siswa,
            'ortu'          => $ortu,
            'sekolah_wali'  => $sekolah_wali,
            'konselor'      => $konselor,
            'siswaMutasi'   => $siswaMutasi,
        ];

        return view($this->views . "/show", $data);
    }

    public function edit($id)
    {
        // Get Data
        $siswa     = $this->mSiswa->where('id', $id)->first();

        if (!$siswa) {
            return redirect()->back()->with('gagal', 'Data tidak ditemukan atau sudah dihapus.');
        }

        if(session()->get('role') == 1){
            $kelaskode = $this->mPerpusKelasKode->get();

            $where = [
                'status' => 1,
            ];
            $konselor   = $this->mKonselor->where($where)->get();
        }else if(session()->get('role') == 2){
            $kelaskode = $this->mPerpusKelasKode->where('idPSekolah', session()->get('idPSekolah'))->get();

            $where = [
                'status' => 1,
                'idPSekolah'=> session()->get('idPSekolah'),
            ];
            $konselor   = $this->mKonselor->where($where)->get();
        }
        
        $agama     = $this->mAgama->get();
        $tempat     = $this->mTempat->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Edit Data Siswa',
            'id'            => $id,
            'siswa'         => $siswa,
            'kelaskode'     => $kelaskode,
            'agama'         => $agama,
            'tempat'        => $tempat,
            'konselor'      => $konselor,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        $request->validate([
            'idPKKode'      => 'required',
            'idSKonselor'   => 'required',
            'idMAgama'      => 'required',
            'nisn'          => 'required',
            'nama'          => 'required',
            'telp'          => 'required',
            'email'         => 'required',
            'lahir_tanggal' => 'required',
            'lahir_tempat'  => 'required',
        ]);
        
        $dataSiswa = [
            'idPKKode'      => $request->idPKKode,
            'idSKonselor'   => $request->idSKonselor,
            'idMAgama'      => $request->idMAgama,
            'nisn'          => $request->nisn,
            'nama'          => $request->nama,
            'telp'          => $request->telp,
            'email'         => $request->email,
            'lahir_tanggal' => $request->lahir_tanggal,
            'lahir_tempat'  => $request->lahir_tempat,
        ];
        $this->mSiswa->where('id', $id)->update($dataSiswa);

        return redirect("$this->url")->with('sukses', 'Data Siswa berhasil di edit');
    }

    public function delete($id)
    {
        try {
            if(session()->get('role') == 1){
                $this->mSiswa->where('id', $id)->delete();
            }else if(session()->get('role') == 2){
                $this->mSiswa->where('id', $id)->where('idPSekolah', session()->get('idPSekolah'))->delete();
            }

            return redirect("$this->url")->with('sukses', 'Data Siswa berhasil di hapus');
        
        }catch (\Exception $e) {
            DB::rollback();
            // error message
            return redirect("$this->url")->with('gagal', 'Terjadi error: '. $e->getMessage());
        }
    }
}
