<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Siswa;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;


use App\Models\Siswa\SiswaModel;
use App\Models\Master\PekerjaanModel;
use App\Models\Siswa\OrtuModel;
use App\Models\Stakeholder\KonselorModel;

class OrtuController extends Controller
{
    private $views      = 'admin/siswa/ortu';
    private $url        = 'admin/siswa/ortu';
    private $url2       = 'admin/siswa';
    private $title      = 'Halaman Ortu';

public function __construct()
    {
        createLogActivity();
        $this->mSiswa           = new SiswaModel();
        $this->mPekerjaan       = new PekerjaanModel();
        $this->mOrtu            = new OrtuModel();
        $this->mKonselor        = new KonselorModel();
    
    }

    public function index()
    {
        if(session()->get('role') == 1){
            $ortu = $this->mOrtu->get();
        }else if(session()->get('role') == 2){
            $ortu = $this->mOrtu->where('idPSekolah', session()->get('idPSekolah'))->get();
        }

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Ortu',
            'ortu'          => $ortu,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        if(session()->get('role') == 1){
            $siswa = $this->mSiswa->get();
        }else if(session()->get('role') == 2){
            $whereSiswa = [
                'idPSekolah'        => session()->get('idPSekolah'),
                'idPPeriode'        => session()->get('idPPeriode'),
                'idMStatus'         => 1,
                'idPPkelas'         => 1,
                'idPPStatus'        => 1,
            ];
            $siswa = $this->mSiswa->where($whereSiswa)->get();
        }
        $pekerjaan = $this->mPekerjaan->get();


        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Ortu',
            'siswa'      => $siswa,
            'pekerjaan'      => $pekerjaan,
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {

        $dataOrtu = [
            'idSiswa'       => $request->idSiswa,
            'idMPekerjaan'  => $request->idMPekerjaan,
            'nama'          => $request->nama,
            'alamat'        => $request->alamat,
            'telp'          => $request->telp,
        ];
        $this->mOrtu->create($dataOrtu);

        return redirect("$this->url")->with('sukses', 'Ortu berhasil di tambahkan');
    }

    public function show($id)
    {
        // Get Data
        $pekerjaan = $this->mPekerjaan->get();

        if(session()->get('role') == 1){
            $ortu      = $this->mOrtu->where('idSiswa', $id)->first();
        }else if(session()->get('role') == 2){
            $ortu      = $this->mOrtu->where('idSiswa', $id)->where('idPSekolah', session()->get('idPSekolah'))->first();
        }

        $data = [
            'title'        => $this->title,
            'url'          => $this->url,
            'url2'         => $this->url2,
            'page'         => 'Detail Data Orang Tua',
            'id'           => $id,
            'pekerjaan'    => $pekerjaan,
            'ortu'         => $ortu,
        ];
        return view($this->views . "/show", $data);
    }

    public function edit($id)
    {
        // Get Data

        if(session()->get('role') == 1){
            $ortu      = $this->mOrtu->where('idSiswa', $id)->first();
            $siswa      = $this->mSiswa->get();
        }else if(session()->get('role') == 2){
            $ortu      = $this->mOrtu->where('idSiswa', $id)->where('idPSekolah', session()->get('idPSekolah'))->first();
            $whereSiswa = [
                'idPSekolah'        => session()->get('idPSekolah'),
                'idPPeriode'        => session()->get('idPPeriode'),
                'idPPkelas'         => 1,
                'idPPStatus'        => 1,
            ];
            $siswa      = $this->mSiswa->where($whereSiswa)->get();
        }

        $pekerjaan  = $this->mPekerjaan->get();

        $data = [
            'title'     => $this->title,
            'url'       => $this->url,
            'page'      => 'Edit Data Ortu',
            'id'        => $id,
            'ortu'     => $ortu,
            'siswa'     => $siswa,
            'pekerjaan'     => $pekerjaan,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        
        $dataOrtu = [
            'idMPekerjaan'      => $request->idMPekerjaan,
            'nama'              => $request->nama,
            'alamat'            => $request->alamat,
            'telp'              => $request->telp,
        ];

        if(session()->get('role') == 1){
            $this->mOrtu->where('id', $id)->update($dataOrtu);
        }else if(session()->get('role') == 2){
            $this->mOrtu->where('id', $id)->where('idPSekolah', session()->get('idPSekolah'))->update($dataOrtu);
        }

        return redirect()->back()->with('sukses', 'Data Ortu berhasil di edit');
    }

    public function destroy($id)
    {
        //
    }
}
