<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Perpus;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\JurusanModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;

class KelasController extends Controller
{
    private $views      = 'admin/perpus/kelas';
    private $url        = 'admin/master/sekolah/tingkat';
    private $url2        = 'admin/master/sekolah/indeks-kelas';
    private $title      = 'Halaman Data Tingkat';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct. Biasanya saya isi untuk Model

        $this->mPerpusSekolah         = new SekolahModel();
        $this->mPerpusJurusan         = new JurusanModel();
        $this->mPerpusKelas         = new KelasModel();
        $this->mPerpusKelasKode         = new KelasKodeModel();
    
    }

    public function index()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Tingkat',
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Tingkat',
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {

        $dataPerpusKelas = [
            'idPSekolah'      => $request->idPSekolah,
            'idPJurusan'      => $request->idPJurusan,
            'nama'            => $request->nama,
        ];
        $this->mPerpusKelas->create($dataPerpusKelas);

        return redirect("$this->url")->with('sukses', 'Data Kelas berhasil di tambahkan');
    }

    public function show($id)
    {
        if(session()->get('role') == 1){
            $perpus_kelas           = $this->mPerpusKelas->where('id', $id)->first();
        }else if(session()->get('role') == 2){
            $perpus_kelas           = $this->mPerpusKelas->where('id', $id)->where('idPSekolah', session()->get('idPSekolah'))->first();
        }

        if (!$perpus_kelas) {
            abort(404);
        }

        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'url2'              => $this->url2,
            'page'              => 'Detail Data Tingkat',
            'id'                => $id,
            'perpus_kelas'      => $perpus_kelas,
        ];
        return view($this->views . "/show", $data);
    }

    public function edit($id)
    {
        if(session()->get('role') == 1){
            $perpus_kelas   = $this->mPerpusKelas->where('id', $id)->first();
        }else if(session()->get('role') == 2){
            $perpus_kelas   = $this->mPerpusKelas->where('id', $id)->where('idPSekolah', session()->get('idPSekolah'))->first();
        }

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Edit Data Tingkat',
            'id'            => $id,
            'perpus_kelas'  => $perpus_kelas,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        $request->validate([
            'nama'        => 'required',
        ]);

        $this->mPerpusKelas->where('id', $request->id)->update(['nama' => $request->nama]);

        return redirect("$this->url")->with('sukses', 'Data Tingkat berhasil di edit');
    }

    public function delete($id)
    {
        try {
            if(session()->get('role') == 1){
                $this->mPerpusKelas->where('id', $id)->delete();
                $this->mPerpusKelasKode->where('idPKelas', $id)->delete();
            }else if(session()->get('role') == 2){
                $this->mPerpusKelas->where('id', $id)->where('idPSekolah', session()->get('idPSekolah'))->delete();
                $this->mPerpusKelasKode->where('idPKelas', $id)->where('idPSekolah', session()->get('idPSekolah'))->delete();
            }

            return redirect("$this->url")->with('sukses', 'Data tingkat beserta indeks kelas di dalam nya berhasil di hapus');
        
        }catch (\Exception $e) {
            DB::rollback();
            // error message
            return redirect("$this->url")->with('gagal', 'Terjadi error: '. $e->getMessage());
        }
    }
}
