<?php

namespace App\Http\Controllers\Admin\Master;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
// Panggil Nama file Model yang mau dipake
use App\Models\Master\ProvinsiModel;

class ProvinsiController extends Controller
{

    private $views      = 'admin/master/provinsi';
    private $url        = 'admin/master/provinsi';
    private $title      = 'Halaman Master Provinsi';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct. Biasanya saya isi untuk Model

        $this->mProvinsi         = new ProvinsiModel();
    
    }

    public function index()
    {
        $provinsi = $this->mProvinsi->get();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Master Provinsi',
            // Untuk pemanggilan data provinsi
            'provinsi'          => $provinsi,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Master Provinsi',
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {

        $dataProvinsi = [
            'nama'      => $request->nama,
        ];
        $this->mProvinsi->create($dataProvinsi);

        return redirect("$this->url")->with('sukses', 'Provinsi berhasil di tambahkan');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        // Get Data
        $provinsi      = $this->mProvinsi->where('id', $id)->first();

        $data = [
            'title'     => $this->title,
            'url'       => $this->url,
            'page'      => 'Edit Data Provinsi',
            'id'        => $id,
            'provinsi'    => $provinsi,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        $request->validate([
            'id' => 'required',
            'nama' => 'required',
        ]);
        
        $dataProvinsi = [
                'nama'      => $request->nama,
            ];
        $this->mProvinsi->where('id', $request->id)->update($dataProvinsi);

        // Response
        return redirect("$this->url")->with('sukses', 'Data Provinsi berhasil di edit');
    }

    public function destroy($id)
    {
        //
    }
}
