<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Master;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Master\PeriodeModel;

class PeriodeController extends Controller
{
    private $views      = 'admin/master/periode';
    private $url        = 'admin/master/periode';
    private $title      = 'Halaman Data Periode';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct. Biasanya saya isi untuk Model


        $this->mPerpusPeriode         = new PeriodeModel();
    
    }

    public function index()
    {
        $periode = $this->mPerpusPeriode->get();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Periode',
            'periode'       => $periode,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Periode',
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        // if periode yang sekarang ditolak
        $dataPeriode = [
            'nama'              => $request->nama,
            'nama_periode'      => $request->nama_periode,
        ];
        // echo json_encode($dataUser); die;
        $this->mPerpusPeriode->create($dataPeriode);

        return redirect("$this->url")->with('sukses', 'Data Periode berhasil di tambahkan');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {
        //
    }
}
