<?php

namespace App\Http\Controllers\Admin\Layanan\Surat;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;

use App\Models\Siswa\SiswaModel;
use App\Models\Siswa\OrtuModel;

use App\Models\Layanan\Surat\SUndangOrtuModel;

use PhpOffice\PhpWord\TemplateProcessor;

class SUndangOrtuController extends Controller
{
    private $views      = 'admin/layanan/surat/surat_undangOrtu';
    private $url        = 'admin/layanan/surat/undangan/ortu';
    private $title      = 'Halaman Form Undangan Orang Tua';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPeriode         = New PeriodeModel();
        
        $this->mPerpusJurusan   = new JurusanModel();
        $this->mPerpusKelas     = new KelasModel();
        $this->mKelasKode       = new KelasKodeModel();
        $this->mPerpusSekolah   = new SekolahModel();

        $this->mKepsek          = New KepsekModel();

        $this->mSiswa           = New SiswaModel();
        $this->mOrtu            = New OrtuModel();

        $this->mUndangOrtu      = New SUndangOrtuModel();
    }

    public function index()
    {
        $wherenyaa = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idSKonselor'   => session()->get('idSKonselor'),
        ];
        $undangOrtu = $this->mUndangOrtu->where($wherenyaa)->get();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Undangan Orang Tua',
            'undangOrtu'    => $undangOrtu,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Permintaan Surat Undangan Orang Tua',
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $whereKep = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'status'        => 1
        ];
        $kepsek = $this->mKepsek->where($whereKep)->first();
        if(!isset($kepsek)){
            return redirect("$this->url")->with('gagal', 'Kepala Sekolah belum di set');
        };
        $siswa = $this->mSiswa->where('id', $request->idSiswa)->first();
        $ortu = $this->mOrtu->where('idSiswa', $siswa['id'])->first();
        if(!isset($ortu)){
            return redirect("$this->url")->with('gagal', 'Data Ortu tidak ditemukan');
        };

        $suratWaktu = $request->surat_waktu;  
        $suratWaktunew = date("d-m-Y", strtotime($suratWaktu));  

        $isian_tanggal = $request->isian_tanggal;  
        $isiantanggalnew = date("d-m-Y", strtotime($isian_tanggal));  
        $dataUndangOrtu = [
            'idPSekolah'            => session()->get('idPSekolah'),
            'idSiswa'               => $request->idSiswa,
            'idPKKode'              => $request->idPKKode,
            'idPPeriode'            => session()->get('idPPeriode'),
            'idSKepsek'             => $kepsek['id'],
            'idOrtu'                => $ortu['id'],
            'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'nomor'                 => $request->nomor,
            'panggilan_berapa'      => $request->panggilan_berapa,
            'isian_hari'            => $request->isian_hari,
            'isian_tanggal'         => $isiantanggalnew,
            'isian_pukul'           => $request->isian_pukul,
            'isian_keperluan'       => $request->isian_keperluan,
            'isian_bertemu'         => $request->isian_bertemu,
            'idSKonselor'           => session()->get('idSKonselor'),
        ];
        $this->mUndangOrtu->create($dataUndangOrtu);
        // return redirect("$this->url")->with('sukses', 'Permintaan Surat berhasil di tambah');
        // echo json_encode($kepsek); die;
        $undangOrtu = $this->mUndangOrtu->where('kode_unik', $dataUndangOrtu['kode_unik'])->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Undangan Orang Tua',
            'undangOrtu'    => $undangOrtu,
        ];
        return view($this->views . "/show", $data);
    }

    public function show($id)
    {
        // Get Data
        $undangOrtu = $this->mUndangOrtu->where('kode_unik', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Undangan Orang Tua',
            'undangOrtu'    => $undangOrtu,
        ];
        return view($this->views . "/show", $data);
    }

    public function download($id)
    {
        if (!cekKopSurat(session()->get('idPSekolah'))) {
            return redirect("admin/dashboard")->with('gagal', 'Kop Surat tidak ditemukan, mohon upload ulang melalui login Admin Sekolah');
        }
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $undangOrtu = $this->mUndangOrtu->where('kode_unik', $id)->first();
        // dd($undangOrtu);
        $dataUndangOrtu = [
            'namaSekolah'       => $sekolah->nama,
            'KopSurat'          => $sekolah->logo,
            'panggilan_berapa'  => $undangOrtu->panggilan_berapa,
            'nomor'             => $undangOrtu->nomor,
            'surat_waktu'       => $undangOrtu->surat_waktu, // tanggal surat
            'isian_tanggal'     => $undangOrtu->isian_tanggal, // tanggal panggil
            'idSiswa'           => $undangOrtu->siswa->nama,
            'idPKKode'          => $undangOrtu->kelaskode->kelas->nama.' '.$undangOrtu->kelaskode->kelas->jurusan->nama.' '.$undangOrtu->kelaskode->nama,
            'isian_hari'        => $undangOrtu->isian_hari,
            'isian_pukul'       => $undangOrtu->isian_pukul,
            'isian_keperluan'   => $undangOrtu->isian_keperluan,
            'idOrtu'            => $undangOrtu->ortu->nama,
            'idSKepsek'         => $undangOrtu->kepsek->guru->nama ?? 'Kepsek belum di SET',
            'nipKepsek'         => $undangOrtu->kepsek->guru->nip ?? 'Kepsek belum di SET',
            'isian_bertemu'     => $undangOrtu->isian_bertemu,
            'surat_tempat'     => $undangOrtu->surat_tempat,
        ];
        // pakai dari sini. sambil buka word coba.docx
        $templateProcessor = new TemplateProcessor('word-template/surat/surat_undangan_ortu.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$dataUndangOrtu['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('panggilanKe', $dataUndangOrtu['panggilan_berapa']); // untuk isi ${nama} di word
        $templateProcessor->setValue('namaSekolah', $dataUndangOrtu['namaSekolah']);
        $templateProcessor->setValue('tanggalSurat', $dataUndangOrtu['surat_waktu']);
        $templateProcessor->setValue('nomorSurat', $dataUndangOrtu['nomor']);
        $templateProcessor->setValue('namaOrtu', $dataUndangOrtu['idOrtu']); 
        $templateProcessor->setValue('namaSiswa', $dataUndangOrtu['idSiswa']); 
        $templateProcessor->setValue('kelasSiswa', $dataUndangOrtu['idPKKode']); 
        $templateProcessor->setValue('hariPanggil', $dataUndangOrtu['isian_hari']);
        $templateProcessor->setValue('tanggalPanggil', $dataUndangOrtu['isian_tanggal']);
        $templateProcessor->setValue('pukul', $dataUndangOrtu['isian_pukul']); 
        $templateProcessor->setValue('keperluan', $dataUndangOrtu['isian_keperluan']);
        $templateProcessor->setValue('namaKepsek', $dataUndangOrtu['idSKepsek']);
        $templateProcessor->setValue('nipKepsek', $dataUndangOrtu['nipKepsek']); 
        $templateProcessor->setValue('isian_bertemu', $dataUndangOrtu['isian_bertemu']); 
        $templateProcessor->setValue('surat_tempat', $dataUndangOrtu['surat_tempat']); 
        $fileName = 'UNDANGAN ORANG TUA'; // nama filenya
        

        // biar bisa dunlud
        $templateProcessor->saveAs('tempor/' . $fileName . '.docx');
        return response()->download('tempor/' . $fileName . '.docx')->deleteFileAfterSend(true);
        // dd($dataUndangOrtu); 
    }

    public function edit($id){
        $undangOrtu = $this->mUndangOrtu->where('kode_unik', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Undang Orang Tua',
            'id'            => $id,
            'undangOrtu'    => $undangOrtu,
        ];

        return view($this->views . "/edit", $data);

    }

    public function update(Request $request, $id)
    {
        $dataUbah = $this->mUndangOrtu->where('kode_unik', $id)->first();

        if (isset($request->surat_waktu)) {
            $suratWaktu     = $request->surat_waktu;
            $suratWaktunew  = date("d-m-Y", strtotime($suratWaktu));
        } else {
            $suratWaktunew     = $dataUbah->surat_waktu;  
        }

        if (isset($request->isian_tanggal)) {
            $isian_tanggal     = $request->isian_tanggal;
            $isiantanggalnew  = date("d-m-Y", strtotime($isian_tanggal));
        } else {
            $isiantanggalnew     = $dataUbah->isian_tanggal;  
        }
 
        $dataUndangOrtu = [
            // 'idPSekolah'            => session()->get('idPSekolah'),
            // 'idSiswa'               => $request->idSiswa,
            // 'idPKKode'              => $request->idPKKode,
            // 'idPPeriode'            => session()->get('idPPeriode'),
            // 'idSKepsek'             => $kepsek['id'],
            // 'idOrtu'                => $ortu['id'],
            // 'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'nomor'                 => $request->nomor,
            'panggilan_berapa'      => $request->panggilan_berapa,
            'isian_hari'            => $request->isian_hari,
            'isian_tanggal'         => $isiantanggalnew,
            'isian_pukul'           => $request->isian_pukul,
            'isian_keperluan'       => $request->isian_keperluan,
            'isian_bertemu'         => $request->isian_bertemu,
            'idSKonselor'           => session()->get('idSKonselor'),
        ];
        
        $this->mUndangOrtu->where('kode_unik', $id)->update($dataUndangOrtu);

        return redirect("$this->url")->with('sukses', 'Data Surat Undang Orang Tua untuk '.$dataUbah->siswa->nama.' berhasil di edit');
    }

    public function destroy($id)
    {
        $this->mUndangOrtu->where('kode_unik', $id)->delete();

        return redirect("$this->url")->with('sukses', 'Data Surat Undang Orang Tua berhasil di hapus');
    }
}
