<?php

namespace App\Http\Controllers\Admin\Layanan\Surat;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use PhpOffice\PhpWord\TemplateProcessor;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\SekolahWaliModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruModel;

use App\Models\Siswa\SiswaModel;
use App\Models\Siswa\OrtuModel;

use App\Models\Layanan\Surat\DaftarPTModel;

class SPDaftarPTController extends Controller
{
    private $views      = 'admin/layanan/surat/sp_daftarpt';
    private $url        = 'admin/layanan/surat/daftar/pt';
    private $title      = 'Halaman Form Keterangan Daftar Perguruan Tinggi';

public function __construct()
    {
        createLogActivity();
        $this->mPeriode         = New PeriodeModel();
        
        $this->mPerpusSekolah   = New SekolahModel();
        $this->mPerpusJurusan   = New JurusanModel();
        $this->mPerpusKelas     = New KelasModel();
        $this->mKelasKode       = New KelasKodeModel();

        $this->mKepsek          = New KepsekModel();
        $this->mSekolahWali     = new SekolahWaliModel();
        $this->mKonselor        = New KonselorModel();
        $this->mGuru            = New GuruModel();

        $this->mSiswa           = New SiswaModel();
        $this->mOrtu            = New OrtuModel();

        $this->mDaftarPT        = New DaftarPTModel();
    }

    public function index()
    {
        $wherenyaa = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idSKonselor'   => session()->get('idSKonselor'),
        ];
        $daftar_pt = $this->mDaftarPT->where($wherenyaa)->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Keterangan Daftar Perguruan Tinggi',
            'daftar_pt'     => $daftar_pt
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Permintaan Surat Keterangan Daftar Perguruan Tinggi',
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $whereKep = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'status'        => 1
        ];
        $kepsek = $this->mKepsek->where($whereKep)->first();

        if(!isset($kepsek)){

            return redirect("$this->url")->with('gagal', 'Kepala Sekolah belum di set');
        };
        
        $suratWaktu     = $request->surat_waktu;  
        $suratWaktunew  = date("d-m-Y", strtotime($suratWaktu));

        $dataDaftarPT = [
            'idPSekolah'            => session()->get('idPSekolah'),
            'idSKonselor'           => session()->get('idSKonselor'),
            'idPKKode'              => $request->idPKKode,
            'idPPeriode'            => session()->get('idPPeriode'),
            'idSiswa'               => $request->idSiswa,
            'idSKepsek'             => $kepsek['id'],
            'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'nomor'                 => $request->nomor,
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_keterangan'      => $request->isian_keterangan,
        ];
        $this->mDaftarPT->create($dataDaftarPT);

        $daftar_pt = $this->mDaftarPT->where('kode_unik', $dataDaftarPT['kode_unik'])->first();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Keterangan Daftar Perguruan Tinggi',
            'daftar_pt'     => $daftar_pt,
        ];

        return view($this->views . "/show", $data)->with('sukses', 'Surat Daftar Perguruan Tinggi berhasil di tambah');
    }

    public function show($id)
    {
        // Get Data
        $daftar_pt = $this->mDaftarPT->where('kode_unik', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Keterangan Daftar Perguruan Tinggi',
            'daftar_pt'     => $daftar_pt,
        ];
        return view($this->views . "/show", $data);
    }

    public function download($id)
    {
        if (!cekKopSurat(session()->get('idPSekolah'))) {
            return redirect("admin/dashboard")->with('gagal', 'Kop Surat tidak ditemukan, mohon upload ulang melalui login Admin Sekolah');
        }
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $daftar_pt = $this->mDaftarPT->where('kode_unik', $id)->first();
        // dd($mundur);
        
        $dataDaftarPT = [
            'namaSekolah'           => $sekolah->nama,
            'KopSurat'              => $sekolah->logo,
            'idPSekolah'            => $daftar_pt->idPSekolah,
            'idPKKode'              => $daftar_pt->kelaskode->kelas->nama.' '.$daftar_pt->kelaskode->kelas->jurusan->nama.' '.$daftar_pt->kelaskode->nama,
            'idPJurusan'            => $daftar_pt->kelaskode->kelas->jurusan->nama,
            'idPPeriode'            => $daftar_pt->idPPeriode,
            'idSiswa'               => $daftar_pt->siswa->nama,
            'nisn'                  => $daftar_pt->siswa->nisn,
            'nomor'                 => $daftar_pt->nomor,
            'idSKepsek'             => $daftar_pt->kepsek->guru->nama ?? 'Kepsek belum di SET',
            'nipKepsek'             => $daftar_pt->kepsek->guru->nip ?? 'Kepsek belum di SET',
            'surat_tempat'          => $daftar_pt->surat_tempat,
            'surat_waktu'           => $daftar_pt->surat_waktu,
            'isian_keterangan'      => $daftar_pt->isian_keterangan,
        ];
        // pakai dari sini. sambil buka word coba.docx
        $templateProcessor = new TemplateProcessor('word-template/surat/surat_keterangan_daftarpt2.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$dataDaftarPT['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('namaSekolah', $dataDaftarPT['namaSekolah']); 
        $templateProcessor->setValue('namaSiswa', $dataDaftarPT['idSiswa']); 
        $templateProcessor->setValue('kelasSiswa', $dataDaftarPT['idPKKode']); 
        $templateProcessor->setValue('jurusanSekolah', $dataDaftarPT['idPJurusan']);
        $templateProcessor->setValue('noIndukSiswa', $dataDaftarPT['nisn']); 
        $templateProcessor->setValue('suratTempat', $dataDaftarPT['surat_tempat']); 
        $templateProcessor->setValue('tanggalSurat', $dataDaftarPT['surat_waktu']);
        $templateProcessor->setValue('noSurat', $dataDaftarPT['nomor']);
        $templateProcessor->setValue('namaKepsek', $dataDaftarPT['idSKepsek']);
        $templateProcessor->setValue('nipKepsek', $dataDaftarPT['nipKepsek']);
        $templateProcessor->setValue('isian_keterangan', $dataDaftarPT['isian_keterangan']); 
        $fileName = 'Surat Keterangan Daftar Perguruan Tinggi'; // nama filenya
        

        // biar bisa dunlud
        $templateProcessor->saveAs('tempor/' . $fileName . '.docx');
        return response()->download('tempor/' . $fileName . '.docx')->deleteFileAfterSend(true);
        // dd($dataTartib);
    }

    public function edit($id){
        $daftar_pt = $this->mDaftarPT->where('kode_unik', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Keterangan Daftar Perguruan Tinggi',
            'daftar_pt'     => $daftar_pt,
        ];

        return view($this->views . "/edit", $data);

    }

    public function update(Request $request, $id)
    {
        $dataUbah = $this->mDaftarPT->where('kode_unik', $id)->first();

        if (isset($request->surat_waktu)) {
            $suratWaktu     = $request->surat_waktu;
            $suratWaktunew  = date("d-m-Y", strtotime($suratWaktu));
        } else {
            $suratWaktunew     = $dataUbah->surat_waktu;  
        }

        $dataDaftarPT = [
            // yang dicomment yang tidak berubah ya
            // 'idPSekolah'            => session()->get('idPSekolah'),
            // 'idPKKode'              => $request->idPKKode,
            // 'idPPeriode'            => session()->get('idPPeriode'),
            // 'idSiswa'               => $request->idSiswa,
            // 'idSKepsek'             => $kepsek['id'],
            // 'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'nomor'                 => $request->nomor,
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_keterangan'      => $request->isian_keterangan,
        ];
        
        $this->mDaftarPT->where('kode_unik', $id)->update($dataDaftarPT);

        return redirect("$this->url")->with('sukses', 'Data Surat Keterangan Daftar Perguruan Tinggi untuk '.$dataUbah->siswa->nama.' berhasil di edit');
    }

    public function destroy($id)
    {
        $this->mDaftarPT->where('kode_unik', $id)->delete();

        return redirect("$this->url")->with('sukses', 'Data Surat Keterangan Daftar Perguruan Tinggi berhasil di hapus');
    }
}
