<?php

namespace App\Http\Controllers\Admin\Layanan\Surat;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruModel;

use App\Models\Siswa\SiswaModel;
use App\Models\Siswa\OrtuModel;

use App\Models\Layanan\Surat\SKDipulangkanModel;

use PhpOffice\PhpWord\TemplateProcessor;

class SKDipulangkanController extends Controller
{
    private $views      = 'admin/layanan/surat/sk_dipulangkan';
    private $url        = 'admin/layanan/surat/keterangan/dipulangkan';
    private $title      = 'Halaman Form Siswa Dipulangkan';

public function __construct()
    {
        createLogActivity();
        $this->mPeriode         = New PeriodeModel();
        
        $this->mPerpusSekolah   = New SekolahModel();
        $this->mPerpusJurusan   = New JurusanModel();
        $this->mPerpusKelas     = New KelasModel();
        $this->mKelasKode       = New KelasKodeModel();

        $this->mKepsek          = New KepsekModel();
        $this->mKonselor        = New KonselorModel();
        $this->mGuru            = New GuruModel();

        $this->mSiswa           = New SiswaModel();
        $this->mOrtu            = New OrtuModel();

        $this->mDipulangkan     = New SKDipulangkanModel();
    }

    public function index()
    {
        $wherenyaa = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idSKonselor'   => session()->get('idSKonselor'),
        ];
        $dipulangkan = $this->mDipulangkan->where($wherenyaa)->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Siswa Dipulangkan',
            'dipulangkan'   => $dipulangkan
        ];
        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Permintaan Surat Siswa Dipulangkan',
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $siswa = $this->mSiswa->where('id', $request->idSiswa)->first();
        $ortu = $this->mOrtu->where('idSiswa', $siswa['id'])->first();
        if(!isset($ortu)){
            return redirect("$this->url")->with('gagal', 'Data Ortu tidak ditemukan');
        };
        $kelas = $this->mKelasKode->where('id', $siswa['idPKKode']);
        if(!isset($kelas)){
            return redirect("$this->url")->with('gagal', 'Kelas tidak ditemukan');
        };
        $whereKons = [
            'id'            => $siswa['idSKonselor'],
            'status'        => 1,
        ];
        $konselor   = $this->mKonselor->where($whereKons)->first();
        if(!isset($konselor)){
            return redirect("$this->url")->with('gagal', 'Guru Konseling belum di set atau tidak aktif');
        };

        $suratWaktu = $request->surat_waktu;  
        $suratWaktunew = date("d-m-Y", strtotime($suratWaktu));  
        $dataDipulangkan = [
            'idPSekolah'            => session()->get('idPSekolah'),
            'idSKonselor'           => session()->get('idSKonselor'),
            'idPKKode'              => $request->idPKKode,
            'idPPeriode'            => session()->get('idPPeriode'),
            'idSiswa'               => $request->idSiswa,
            'idSKonselor'           => $konselor['id'],
            'idOrtu'                => $ortu['id'],
            'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_alasan'          => $request->isian_alasan,
        ];
        $this->mDipulangkan->create($dataDipulangkan);
        $dipulangkan = $this->mDipulangkan->where('kode_unik', $dataDipulangkan['kode_unik'])->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Siswa Dipulangkan',
            'dipulangkan'   => $dipulangkan,
        ];
        return view($this->views . "/show", $data);
    }

    public function show($id)
    {
        $dipulangkan = $this->mDipulangkan->where('kode_unik', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Siswa Dipulangkan',
            'dipulangkan'   => $dipulangkan,
        ];
        return view($this->views . "/show", $data);
    }

    public function download($id)
    {
        if (!cekKopSurat(session()->get('idPSekolah'))) {
            return redirect("admin/dashboard")->with('gagal', 'Kop Surat tidak ditemukan, mohon upload ulang melalui login Admin Sekolah');
        }
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $dipulangkan = $this->mDipulangkan->where('kode_unik', $id)->first();
        // dd($dipulangkan);
        $datadipulangkan = [
            'KopSurat'          => $sekolah->logo,
            'idSiswa'           => $dipulangkan->siswa->nama,
            'idPKKode'          => $dipulangkan->kelaskode->kelas->nama.' '.$dipulangkan->kelaskode->kelas->jurusan->nama.' '.$dipulangkan->kelaskode->nama,
            'isian_alasan'      => $dipulangkan->isian_alasan,
            'surat_tempat'      => $dipulangkan->surat_tempat,
            'surat_waktu'       => $dipulangkan->surat_waktu, // tanggal panggil
            'idOrtu'            => $dipulangkan->ortu->nama,
            'idSKonselor'       => $dipulangkan->konselor->guru->nama ?? 'Guru Konseling belum di SET',
            'nipKonselor'       => $dipulangkan->konselor->guru->nip ?? 'Guru Konseling belum di SET',
        ];
        // pakai dari sini. sambil buka word coba.docx
        $templateProcessor = new TemplateProcessor('word-template/surat/surat_keterangan_dipulangkan.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$datadipulangkan['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('namaSiswa', $datadipulangkan['idSiswa']); 
        $templateProcessor->setValue('kelasSiswa', $datadipulangkan['idPKKode']); 
        $templateProcessor->setValue('alasan', $datadipulangkan['isian_alasan']);
        $templateProcessor->setValue('surat_tempat', $datadipulangkan['surat_tempat']); 
        $templateProcessor->setValue('tanggalSurat', $datadipulangkan['surat_waktu']);
        $templateProcessor->setValue('namaOrtu', $datadipulangkan['idOrtu']); 
        $templateProcessor->setValue('namaKonselor', $datadipulangkan['idSKonselor']);
        $templateProcessor->setValue('nipKonselor', $datadipulangkan['nipKonselor']); 
        $fileName = 'Surat Siswa Dipulangkan'; // nama filenya
        

        // biar bisa dunlud
        $templateProcessor->saveAs('tempor/' . $fileName . '.docx');
        return response()->download('tempor/' . $fileName . '.docx')->deleteFileAfterSend(true);
        // dd($datadipulangkan); 
    }

    public function edit($id){
        $dipulangkan = $this->mDipulangkan->where('kode_unik', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Keterangan Daftar Perguruan Tinggi',
            'dipulangkan'     => $dipulangkan,
        ];

        return view($this->views . "/edit", $data);

    }

    public function update(Request $request, $id)
    {
        $dataUbah = $this->mDipulangkan->where('kode_unik', $id)->first();

        if (isset($request->surat_waktu)) {
            $suratWaktu     = $request->surat_waktu;
            $suratWaktunew  = date("d-m-Y", strtotime($suratWaktu));
        } else {
            $suratWaktunew     = $dataUbah->surat_waktu;  
        }

        $dataDipulangkan = [
            // 'idPSekolah'            => session()->get('idPSekolah'),
            // 'idSKonselor'           => session()->get('idSKonselor'),
            // 'idPKKode'              => $request->idPKKode,
            // 'idPPeriode'            => session()->get('idPPeriode'),
            // 'idSiswa'               => $request->idSiswa,
            // 'idSKonselor'           => $konselor['id'],
            // 'idOrtu'                => $ortu['id'],
            // 'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_alasan'          => $request->isian_alasan,
        ];
        
        $this->mDipulangkan->where('kode_unik', $id)->update($dataDipulangkan);

        return redirect("$this->url")->with('sukses', 'Data Surat Keterangan Dipulangkan untuk '.$dataUbah->siswa->nama.' berhasil di edit');
    }

    public function destroy($id)
    {
        $this->mDipulangkan->where('kode_unik', $id)->delete();

        return redirect("$this->url")->with('sukses', 'Data Surat Keterangan Dipulangkan berhasil di hapus');
    }
}
