<?php

namespace App\Http\Controllers\Admin\Layanan;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Layanan\SaranModel;
use App\Models\User\UserModel;

use PhpOffice\PhpWord\TemplateProcessor;

class SaranAdminController extends Controller
{
    private $views      = 'admin/saran';
    private $url        = 'admin/saran';
    private $title      = 'Halaman Data Saran';


public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mSaran         = new SaranModel();
        $this->mUsers         = new UserModel();
    }
    
    public function index()
    {
        // echo json_encode(session()->all()); die;
        if(session()->get('role') == 1){
            $saran = $this->mSaran->get();
        }else if(session()->get('role') == 2){
            $saran = $this->mSaran->where('idUser', session()->get('users_id'))->get();
        }else if(session()->get('role') == 3){
            $saran = $this->mSaran->where('idUser', session()->get('users_id'))->get();
        }

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Saran',
            'saran'         => $saran,
        ];
        return view($this->views . "/index", $data);
        // dd(session()->all());
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Saran',
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $dataSaran = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idUser'        => session()->get('users_id'),
            'idAdmin'       => '0',
            'nama'          => $request->nama,
            'telp'          => $request->telp,
            'saran'         => $request->saran,
            'status'        => 1,
        ];
        $dataSaran = $this->mSaran->create($dataSaran);

        return redirect("$this->url")->with('sukses', 'Data Saran berhasil di tambahkan');
    }

    public function show($id)
    {
        if(session()->get('role') == 1){
            $saran               = $this->mSaran->where('id', $id)->first();
        }else if(session()->get('role') == 2){
            $saran               = $this->mSaran->where('id', $id)->where('idUser', session()->get('users_id'))->first();
        }else if(session()->get('role') == 3){
            $saran               = $this->mSaran->where('id', $id)->where('idUser', session()->get('users_id'))->first();
        }

        // Get Data

        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'page'                  => 'Detail Data Saran',
            'saran'                 => $saran,
        ];
        return view($this->views . "/show", $data);
    }

    public function edit($id)
    {
        if(session()->get('role') == 1){
            $saran               = $this->mSaran->where('id', $id)->first();
        }else{
            return redirect("$this->url");
        }

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Tanggapan',
            'saran'         => $saran,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        if(session()->get('role') == 1){
            $dataSaran = [
                'tanggapan'     => $request->tanggapan,
                'status'        => 2
            ];
            $this->mSaran->where('id', $id)->update($dataSaran);
        }else{
            return redirect("$this->url");
        }

        return redirect("$this->url")->with('sukses', 'Data Saran berhasil di tanggapi');
    }
}
