<?php

namespace App\Http\Controllers\Admin\Layanan\Konseling;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Master\TempatModel;
use App\Models\Master\PekerjaanModel;
use App\Models\Master\AgamaModel;

use App\Models\Perpus\KelasKodeModel;

use App\Models\Stakeholder\SekolahWaliModel;
use App\Models\Stakeholder\KonselorModel;

use App\Models\Siswa\SiswaModel;
use App\Models\Siswa\OrtuModel;

use App\Models\Layanan\MutasiKonselingModel;

use PhpOffice\PhpWord\TemplateProcessor;

class KonselingController extends Controller
{
    private $views      = 'admin/layanan/konseling/konseling';
    private $url        = 'admin/layanan/konseling/konseling';
    private $title      = 'Halaman Data Konseling';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mMutasiKonseling     = new MutasiKonselingModel();
        $this->mSiswa               = new SiswaModel();

        $this->mPerpusKelasKode     = new KelasKodeModel();
        $this->mAgama               = new AgamaModel();
        $this->mOrtu                = new OrtuModel();
        $this->mSekolahWali         = new SekolahWaliModel();
        $this->mPekerjaan           = new PekerjaanModel();
        $this->mKonselor            = new KonselorModel();
        $this->mTempat              = new TempatModel();
    }

    public function index()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Konseling Siswa',
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Konseling Siswa',
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $siswa = $this->mSiswa->where('id', $request->idSiswa)->first();
        $whereKons = [
            'id'            => $siswa['idSKonselor'],
            'status'        => 1,
        ];
        $konselor   = $this->mKonselor->where($whereKons)->first();
        if(!isset($konselor)){
            return redirect("$this->url")->with('gagal', 'Guru Konseling belum di set atau tidak aktif');
        };
        
        $dataKonseling = [
            'idPSekolah'            => session()->get('idPSekolah'),
            'idPKKode'              => $request->idPKKode,
            'idPPeriode'            => session()->get('idPPeriode'),
            'idSiswa'               => $request->idSiswa,
            'idSKonselor'           => $konselor['id'],
            'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'isian_permasalahan'    => $request->isian_permasalahan,
            'isian_penyelesaian'    => $request->isian_penyelesaian,
        ];

        $this->mMutasiKonseling->create($dataKonseling);

        return redirect($this->url . '/' . $siswa->id)->with('sukses', 'Konseling Siswa Berhasil di Laporkan');
    }

    public function show($id)
    {
        // Get Data
        $siswa              = $this->mSiswa->where('id', $id)->first();
        $konselor           = $this->mKonselor->where('idSGuru', $siswa['idSKonselor'])->first();
        $sekolah_wali       = $this->mSekolahWali->where('idPKKode', $siswa['idPKKode'])->first();
        $ortu               = $this->mOrtu->where('idSiswa', $id)->first();

        // if (!$siswa || !$konselor || !$sekolah_wali || !$ortu) {
        //     return redirect()->back()->with('gagal', 'Data tidak ditemukan atau sudah dihapus.');
        // }

        $where = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idSiswa'       => $siswa['id']
        ];
        $mutasiKonseling   = $this->mMutasiKonseling->where($where)->get();

        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'page'              => 'Detail Data Mutasi Konseling Siswa',
            'id'                => $id,
            'siswa'             => $siswa,
            'ortu'              => $ortu,
            'sekolah_wali'      => $sekolah_wali,
            'gurukonselor'          => $konselor,
            'mutasiKonseling'   => $mutasiKonseling,
        ];
        
        return view($this->views . "/show", $data);
    }
}
