<?php

namespace App\Http\Controllers\Admin\Layanan\Konferensi;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruModel;

use App\Models\Siswa\SiswaModel;

use App\Models\Layanan\Konferensi\KonKegiatanModel;
use App\Models\Layanan\Konferensi\KonRPLModel;

use PhpOffice\PhpWord\TemplateProcessor;

class KonferensiRPLController extends Controller
{
    private $views      = 'admin/layanan/konferensi/konferensi_RPL';
    private $url        = 'admin/layanan/lainnya/konferensi/rpl';
    private $url2       = 'admin/layanan/lainnya/konferensi/kegiatan';
    private $title      = 'Halaman Konferensi RPL';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPeriode             = new PeriodeModel();

        $this->mPerpusSekolah       = new SekolahModel();
        $this->mPerpusJurusan       = new JurusanModel();
        $this->mPerpusKelas         = new KelasModel();
        $this->mPerpusKelasKode     = new KelasKodeModel();

        $this->mKepsek              = new KepsekModel();
        $this->mGuru                = new GuruModel();
        
        $this->mSiswa               = new SiswaModel();
        
        $this->mKonKegiatan         = new KonKegiatanModel();
        $this->mKonselor            = new KonselorModel();
        $this->mKonRPL              = new KonRPLModel();
    }

    public function show($id)
    {
        // Get Data
        $konrpl = $this->mKonRPL->where('id', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'url2'          => $this->url2,
            'page'          => 'Data Konferensi RPL',
            'konrpl'        => $konrpl,
        ];
        return view($this->views . "/show", $data);
    }

    public function download($id)
    {
        if (!cekKopSurat(session()->get('idPSekolah'))) {
            return redirect("admin/dashboard")->with('gagal', 'Kop Surat tidak ditemukan, mohon upload ulang melalui login Admin Sekolah');
        }
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $konrpl = $this->mKonRPL->where('id', $id)->first();
        // dd($mundur);
        $datakonrpl = [
            'KopSurat'              => $sekolah->logo,
            'surat_tempat'          => $konrpl->surat_tempat,
            'surat_waktu'           => $konrpl->surat_waktu,
            'namaKonselor'          => $konrpl->konselor->guru->nama ?? 'Guru Konseling belum di SET',
            'nipKonselor'           => $konrpl->konselor->guru->nip ?? 'Guru Konseling belum di SET',
            'namaKepsek'            => $konrpl->kepsek->guru->nama ?? 'Kepsek belum di SET',
            'nipKepsek'             => $konrpl->kepsek->guru->nip ?? 'Kepsek belum di SET',
            'isian_judul'           => $konrpl->isian_judul,
            'isian_fungsi'          => $konrpl->isian_fungsi,
            'isian_tujuan'          => $konrpl->isian_tujuan,
            'isian_hasil'           => $konrpl->isian_hasil,
            'idSiswa'               => $konrpl->konkegiatan->siswa->nama,
            'isian_gambaran'        => $konrpl->isian_gambaran,
            'isian_tempat'          => $konrpl->isian_tempat,
            'isian_waktu'           => $konrpl->isian_waktu,
            'isian_tanggal'         => $konrpl->isian_tanggal, 
            'isian_semester'        => $konrpl->isian_semester,
            'isian_penyelenggara'   => $konrpl->isian_penyelenggara,
            'isian_pihak'           => $konrpl->isian_pihak,
            'isian_bahan'           => $konrpl->isian_bahan,
            'isian_penggunaan'      => $konrpl->isian_penggunaan,
            'isian_rencana'         => $konrpl->isian_rencana,
            'isian_catatan'         => $konrpl->isian_catatan,
        ];
        // pakai dari sini. sambil buka word coba.docx
        $templateProcessor = new TemplateProcessor('word-template/konferensi_kasus/konferensikasus_kegiatan.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$datakonrpl['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('surat_tempat', $datakonrpl['surat_tempat']); 
        $templateProcessor->setValue('surat_waktu', $datakonrpl['surat_waktu']);
        $templateProcessor->setValue('namaKonselor', $datakonrpl['namaKonselor']);
        $templateProcessor->setValue('nipKonselor', $datakonrpl['nipKonselor']); 
        $templateProcessor->setValue('namaKepsek', $datakonrpl['namaKepsek']);
        $templateProcessor->setValue('nipKepsek', $datakonrpl['nipKepsek']); 
        $templateProcessor->setValue('isian_judul', $datakonrpl['isian_judul']); 
        $templateProcessor->setValue('isian_fungsi', $datakonrpl['isian_fungsi']); 
        $templateProcessor->setValue('isian_tujuan', $datakonrpl['isian_tujuan']); 
        $templateProcessor->setValue('isian_hasil', $datakonrpl['isian_hasil']); 
        $templateProcessor->setValue('idSiswa', $datakonrpl['idSiswa']); 
        $templateProcessor->setValue('isian_gambaran', $datakonrpl['isian_gambaran']); 
        $templateProcessor->setValue('isian_tempat', $datakonrpl['isian_tempat']);
        $templateProcessor->setValue('isian_waktu', $datakonrpl['isian_waktu']); 
        $templateProcessor->setValue('isian_tanggal', $datakonrpl['isian_tanggal']);
        $templateProcessor->setValue('isian_semester', $datakonrpl['isian_semester']); 
        $templateProcessor->setValue('isian_penyelenggara', $datakonrpl['isian_penyelenggara']);
        $templateProcessor->setValue('isian_pihak', $datakonrpl['isian_pihak']); 
        $templateProcessor->setValue('isian_bahan', $datakonrpl['isian_bahan']); 
        $templateProcessor->setValue('isian_penggunaan', $datakonrpl['isian_penggunaan']); 
        $templateProcessor->setValue('isian_rencana', $datakonrpl['isian_rencana']); 
        $templateProcessor->setValue('isian_catatan', $datakonrpl['isian_catatan']); 
        $fileName = 'konferensikasus_kegiatan'; // nama filenya
        

        // biar bisa dunlud
        $templateProcessor->saveAs('tempor/' . $fileName . '.docx');
        return response()->download('tempor/' . $fileName . '.docx')->deleteFileAfterSend(true);
        // dd($datamundur);
    }
}
