<?php

namespace App\Http\Controllers\Admin\Layanan\Konferensi;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\KonselorModel;

use App\Models\Siswa\SiswaModel;

use App\Models\Layanan\Konferensi\KonKegiatanModel;
use App\Models\Layanan\Konferensi\KonRPLModel;
use App\Models\Layanan\Konferensi\KonBeritaAcaraModel;

use PhpOffice\PhpWord\TemplateProcessor;

class KonferensiKegiatanController extends Controller
{
    private $views      = 'admin/layanan/konferensi/konferensi_kegiatan';
    private $url        = 'admin/layanan/lainnya/konferensi/kegiatan';
    private $url2       = 'admin/layanan/lainnya/konferensi/rpl';
    private $url3       = 'admin/layanan/lainnya/konferensi/berita-acara';
    private $title      = 'Halaman Konferensi Kegiatan';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPeriode             = new PeriodeModel();

        $this->mPerpusSekolah       = new SekolahModel();
        $this->mPerpusJurusan       = new JurusanModel();
        $this->mPerpusKelas         = new KelasModel();
        $this->mPerpusKelasKode     = new KelasKodeModel();

        $this->mKepsek              = new KepsekModel();
        $this->mKonselor            = new KonselorModel();

        $this->mSiswa               = new SiswaModel();

        $this->mKonKegiatan         = new KonKegiatanModel();
        $this->mKonRPL              = new KonRPLModel();
        $this->mKonBeritaAcara      = new KonBeritaAcaraModel();
    }

    public function index()
    {
        $wherenyaa = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idSKonselor'   => session()->get('idSKonselor'),
        ];
        $konkegiatan      = $this->mKonKegiatan->where($wherenyaa)->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Konferensi Kegiatan',
            'konkegiatan'   => $konkegiatan,
        ];
        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $periode = $this->mPeriode->get();
        $konselor   = $this->mKonselor->where('idPSekolah', session()->get('idPSekolah'))->get();
        // $kepsek   = $this->mKepsek->where('idPSekolah', session()->get('idPSekolah'))->get();
        $whereKep = [
            'status' => 1,
            'idPSekolah' => session()->get('idPSekolah')
        ];
        $kepsek   = $this->mKepsek->where($whereKep)->get();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Konferensi Kegiatan',
            'periode'       => $periode,
            'konselor'      => $konselor,
            'kepsek'        => $kepsek,
        ];
        return view($this->views . "/create", $data);
    }

    public function show($id)
    {
        // Get Data
        $konKegiatan        = $this->mKonKegiatan->where('kode_unik', $id)->first();
        $konrpl             = $this->mKonRPL->where('idLKKegiatan', $konKegiatan['id'])->first();
        
        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'url2'                  => $this->url2,
            'url3'                  => $this->url3,
            'page'                  => 'Detail Data Konferensi Kegiatan',
            'id'                    => $id,
            'konrpl'                => $konrpl,
            'konkegiatan'           => $konKegiatan,
        ];
        if ($konKegiatan['status'] == 2){
            // PANGGIL MODEL BERITA ACARA 
            $konberitaacara        = $this->mKonBeritaAcara->where('idLKKegiatan', $konKegiatan['id'])->first();
            $data['konberitaacara'] = $konberitaacara;
        }
        // echo json_encode($konrpl); die;

        return view($this->views . "/show", $data);
    }

    public function store(Request $request)
    {
        $siswa = $this->mSiswa->where('id', $request->idSiswa)->first();
        $whereKons = [
            'id'            => $siswa['idSKonselor'],
            'status'        => 1,
        ];
        $konselor   = $this->mKonselor->where($whereKons)->first();
        if(!isset($konselor)){
            return redirect("$this->url")->with('gagal', 'Guru Konseling belum di set atau tidak aktif');
        };

        $whereKep = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'status'        => 1
        ];
        $kepsek = $this->mKepsek->where($whereKep)->first();
        if(!isset($kepsek)){
            return redirect("$this->url")->with('gagal', 'Kepsek belum di set');
        };

        $suratWaktu = $request->surat_waktu;  
        $suratWaktunew = date("d-m-Y", strtotime($suratWaktu));

        $isianWaktu = $request->isian_waktu;  
        $isianWaktunew = date("d-m-Y", strtotime($isianWaktu));
        
        $dataKonKegiatan = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idSKonselor'   => session()->get('idSKonselor'),
            'idPKKode'      => $request->idPKKode,
            'idPPeriode'    => session()->get('idPPeriode'),
            'idSiswa'       => $request->idSiswa,
            'kode_unik'     => strtoupper(bin2hex(random_bytes(3))),
            'status'        => 1
        ];
        $KonKegiatan = $this->mKonKegiatan->create($dataKonKegiatan);
        $dataRPL = [
            'idLKKegiatan'          => $KonKegiatan['id'], // untuk mmebuat relasi yang baik
            'idSKepsek'             => $kepsek['id'],
            'idSKonselor'           => $konselor['id'],
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_judul'           => $request->isian_judul,
            'isian_fungsi'          => $request->isian_fungsi,
            'isian_tujuan'          => $request->isian_tujuan,
            'isian_hasil'           => $request->isian_hasil,
            'isian_gambaran'        => $request->isian_gambaran,
            'isian_tempat'          => $request->isian_tempat,
            'isian_waktu'           => $isianWaktunew,
            'isian_tanggal'         => $request->isian_tanggal,
            'isian_semester'        => $request->isian_semester,
            'isian_penyelenggara'   => $request->isian_penyelenggara,
            'isian_pihak'           => $request->isian_pihak,
            'isian_bahan'           => $request->isian_bahan,
            'isian_penggunaan'      => $request->isian_penggunaan,
            'isian_rencana'         => $request->isian_rencana,
            'isian_catatan'         => $request->isian_catatan,
        ];
        $this->mKonRPL->create($dataRPL);
        return redirect("$this->url")->with('sukses', 'Data Konferensi Kegiatan berhasil di tambahkan');
    }
}
