<?php

namespace App\Http\Controllers\Admin\Layanan\Homevisit;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use PhpOffice\PhpWord\TemplateProcessor;

use App\Models\Master\PeriodeModel;
use App\Models\Master\JabatanModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruModel;

use App\Models\Siswa\SiswaModel;
use App\Models\Siswa\OrtuModel;

use App\Models\Layanan\Homevisit\HomevisitRpl;
use App\Models\Layanan\Homevisit\HomevisitKegiatan;
use App\Models\Layanan\Homevisit\HomevisitTu;
use App\Models\Layanan\Homevisit\HomevisitEvaluasi;

class HomevisitRplController extends Controller
{
    private $views      = 'admin/layanan/homevisit/homevisit_rpl';
    private $url       = 'admin/layanan/lainnya/home/visit/rpl';
    private $url2        = 'admin/layanan/lainnya/home/visit';
    private $title      = 'Halaman Layanan Home Visit RPL';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPeriode                 = New PeriodeModel();
        $this->mJabatan                 = New JabatanModel();
        
        $this->mPerpusJurusan           = new JurusanModel();
        $this->mPerpusKelas             = new KelasModel();
        $this->mKelasKode               = new KelasKodeModel();
        $this->mPerpusSekolah           = new SekolahModel();

        $this->mKepsek                  = New KepsekModel();
        $this->mKonselor                = New KonselorModel();
        $this->mGuru                    = New GuruModel();

        $this->mSiswa                   = New SiswaModel();
        $this->mOrtu                    = New OrtuModel();

        $this->mHomevisitRpl            = new HomevisitRpl();
        $this->mHomevisitKegiatan       = new HomevisitKegiatan();
        $this->mHomevisitTu             = new HomevisitTu();
        $this->mHomevisitEvaluasi       = new HomevisitEvaluasi();
    }

    public function show($id)
    {
        // Get Data
        $homevisit_kegiatan        = $this->mHomevisitKegiatan->where('kode_unik', $id)->first();
        $homevisit_rpl = $this->mHomevisitRpl->where('idLHKegiatan', $homevisit_kegiatan->id)->where('idSKonselor', session()->get('idSKonselor'))->first();

        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'url2'               => $this->url2,
            'page'              => 'Data Layanan Homevisit Rpl',
            'homevisit_rpl'     => $homevisit_rpl,
        ];
        return view($this->views . "/show", $data);
    }

    public function download($id)
    {
        if (!cekKopSurat(session()->get('idPSekolah'))) {
            return redirect("admin/dashboard")->with('gagal', 'Kop Surat tidak ditemukan, mohon upload ulang melalui login Admin Sekolah');
        }
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $homevisit_rpl = $this->mHomevisitRpl->where('id', $id)->where('idSKonselor', session()->get('idSKonselor'))->first();
        
        $dataHomevisitRpl = [
            'KopSurat'              => $sekolah->logo ?? '',
            'namaSiswa'             => $homevisit_rpl->homevisitkegiatan->siswa->nama,
            'namaKonselor'          => $homevisit_rpl->konselor->guru->nama ?? 'Guru Konseling belum di SET',
            'nipKonselor'           => $homevisit_rpl->konselor->guru->nip ?? 'Guru Konseling belum di SET',
            'namaKepsek'            => $homevisit_rpl->kepsek->guru->nama  ?? 'Kepsek belum di SET',
            'nipKepsek'             => $homevisit_rpl->kepsek->guru->nip ?? 'Kepsek belum di SET',
            'namaOrtu'              => $homevisit_rpl->ortu->nama,
            'surat_tempat'          => $homevisit_rpl->surat_tempat,
            'surat_waktu'           => $homevisit_rpl->surat_waktu,
            'isian_judul'           => $homevisit_rpl->isian_judul,
            'isian_bidang'          => $homevisit_rpl->isian_bidang,
            'isian_fungsi'          => $homevisit_rpl->isian_fungsi,
            'isian_tujuan'          => $homevisit_rpl->isian_tujuan,
            'isian_hasil'           => $homevisit_rpl->isian_hasil,
            'isian_gambaran'        => $homevisit_rpl->isian_gambaran,
            'isian_tempat'          => $homevisit_rpl->isian_tempat,
            'isian_waktu'           => $homevisit_rpl->isian_waktu,
            'isian_tanggal'         => $homevisit_rpl->isian_tanggal,
            'isian_semester'        => $homevisit_rpl->isian_semester,
            'isian_petugas'         => $homevisit_rpl->isian_petugas,
            'isian_anggota'         => $homevisit_rpl->isian_anggota,
            'isian_keterangan'      => $homevisit_rpl->isian_keterangan,
            'isian_hasilPertemuan'  => $homevisit_rpl->isian_hasilPertemuan,
            'isian_rencana'         => $homevisit_rpl->isian_rencana,
            'isian_catatan'         => $homevisit_rpl->isian_catatan,
        ];
        $templateProcessor = new TemplateProcessor('word-template/home_visit/homevisit_kepsek.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$dataHomevisitRpl['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('isian_judul', $dataHomevisitRpl['isian_judul']); 
        $templateProcessor->setValue('isian_bidang', $dataHomevisitRpl['isian_bidang']);
        $templateProcessor->setValue('isian_fungsi', $dataHomevisitRpl['isian_fungsi']); 
        $templateProcessor->setValue('isian_tujuan', $dataHomevisitRpl['isian_tujuan']);
        $templateProcessor->setValue('isian_hasil', $dataHomevisitRpl['isian_hasil']);
        $templateProcessor->setValue('isian_gambaran', $dataHomevisitRpl['isian_gambaran']);
        $templateProcessor->setValue('isian_tempat', $dataHomevisitRpl['isian_tempat']);
        $templateProcessor->setValue('isian_waktu', $dataHomevisitRpl['isian_waktu']);
        $templateProcessor->setValue('isian_tanggal', $dataHomevisitRpl['isian_tanggal']);
        $templateProcessor->setValue('isian_semester', $dataHomevisitRpl['isian_semester']);
        $templateProcessor->setValue('isian_petugas', $dataHomevisitRpl['isian_petugas']);
        $templateProcessor->setValue('isian_anggota', $dataHomevisitRpl['isian_anggota']);
        $templateProcessor->setValue('isian_keterangan', $dataHomevisitRpl['isian_keterangan']);
        $templateProcessor->setValue('isian_hasilPertemuan', $dataHomevisitRpl['isian_hasilPertemuan']);
        $templateProcessor->setValue('isian_rencana', $dataHomevisitRpl['isian_rencana']);
        $templateProcessor->setValue('isian_catatan', $dataHomevisitRpl['isian_catatan']);
        $templateProcessor->setValue('suratTempat', $dataHomevisitRpl['surat_tempat']); 
        $templateProcessor->setValue('tanggalSurat', $dataHomevisitRpl['surat_waktu']);
        $templateProcessor->setValue('namaOrtu', $dataHomevisitRpl['namaOrtu']);
        $templateProcessor->setValue('namaSiswa', $dataHomevisitRpl['namaSiswa']);
        $templateProcessor->setValue('namaKepsek', $dataHomevisitRpl['namaKepsek']);
        $templateProcessor->setValue('nipKepsek', $dataHomevisitRpl['nipKepsek']);
        $templateProcessor->setValue('namaKonselor', $dataHomevisitRpl['namaKonselor']);
        $templateProcessor->setValue('nipKonselor', $dataHomevisitRpl['nipKonselor']);
        $fileName = 'RENCANA PELAYANAN BIMBINGAN DAN KONSELING KEGIATAN KUNJUNGAN RUMAH'; // nama filenya
        

        // biar bisa dunlud
        $templateProcessor->saveAs('tempor/' . $fileName . '.docx');
        return response()->download('tempor/' . $fileName . '.docx')->deleteFileAfterSend(true);
        // dd($dataTartib);
    }
}
