<?php

namespace App\Http\Controllers\Admin\Layanan\Homevisit;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use PhpOffice\PhpWord\TemplateProcessor;

use App\Models\Master\PeriodeModel;
use App\Models\Master\JabatanModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruModel;

use App\Models\Siswa\SiswaModel;
use App\Models\Siswa\OrtuModel;

use App\Models\Layanan\Homevisit\HomevisitRpl;
use App\Models\Layanan\Homevisit\HomevisitKegiatan;
use App\Models\Layanan\Homevisit\HomevisitTu;
use App\Models\Layanan\Homevisit\HomevisitEvaluasi;

class HomevisitEvaluasiController extends Controller
{
    private $views      = 'admin/layanan/homevisit/homevisit_evaluasi';
    private $url       = 'admin/layanan/lainnya/home/visit/evaluasi';
    private $url2        = 'admin/layanan/lainnya/home/visit';
    private $title      = 'Halaman Home Visit Evaluasi';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPeriode                 = New PeriodeModel();
        $this->mJabatan                 = New JabatanModel();

        $this->mPerpusJurusan           = new JurusanModel();
        $this->mPerpusKelas             = new KelasModel();
        $this->mKelasKode               = new KelasKodeModel();
        $this->mPerpusSekolah           = new SekolahModel();

        $this->mKepsek                  = New KepsekModel();
        $this->mGuru                    = New GuruModel();
        $this->mKonselor                = New KonselorModel();

        $this->mSiswa                   = New SiswaModel();
        $this->mOrtu                    = New OrtuModel();

        $this->mHomevisitRpl            = new HomevisitRpl();
        $this->mHomevisitKegiatan       = new HomevisitKegiatan();
        $this->mHomevisitTu             = new HomevisitTu();
        $this->mHomevisitEvaluasi       = new HomevisitEvaluasi();
    }

    public function show($id)
    {
        $homevisit_evaluasi = $this->mHomevisitEvaluasi->where('id', $id)->first();
        
        $data = [
            'title'                   => $this->title,
            'url'                     => $this->url,
            'url2'                     => $this->url2,
            'page'                    => 'Data Home Visit Evaluasi',
            'homevisit_evaluasi'      => $homevisit_evaluasi,
        ];
        return view($this->views . "/show", $data);
    }

    public function create($id)
    {
        $homevisit_kegiatan       = $this->mHomevisitKegiatan->where('id', $id)->first();

        $where = [
            'idPsekolah' => session()->get('idPSekolah'),
            'status'     => '1'
        ];
        $konselor   = $this->mKonselor->where($where)->get();
        $kepsek     = $this->mKepsek->where($where)->get();
        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'url2'                   => $this->url2,
            'page'                  => 'Tambah Data Home Visit Evaluasi',
            'konselor'              => $konselor,
            'kepsek'                => $kepsek,
            'homevisit_kegiatan'    => $homevisit_kegiatan,
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request, $id)
    {
        $whereKep = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'status'        => 1
        ];
        $kepsek             = $this->mKepsek->where($whereKep)->first();
        if(!isset($kepsek)){
            return redirect("$this->url")->with('gagal', 'Kepsek belum di set');
        };
        
        // $whereKons = [
        //     'idPSekolah'    => session()->get('idPSekolah'),
        //     'status'        => 1
        // ];
        // $konselor           = $this->mKonselor->where($whereKons)->first();
        // if(!isset($konselor)){
        //     return redirect("$this->url")->with('gagal', 'Guru Konseling belum di set atau tidak aktif');
        // };

        $dataHomevisitEvaluasi = [
            'idLHKegiatan'                      => $id,
            'idSKepsek'                         => $kepsek['id'],
            'idSKonselor'                       => session()->get('idSKonselor'),
            'surat_tempat'                      => $request->surat_tempat,
            'surat_waktu'                       => $request->surat_waktu,
            'isian_topik'                       => $request->isian_topik,
            'isian_bidang'                      => $request->isian_bidang,
            'isian_jenis'                       => $request->isian_jenis,
            'isian_fungsi'                      => $request->isian_fungsi,
            'isian_sasaran'                     => $request->isian_sasaran,
            'isian_kompetensi'                  => $request->isian_kompetensi,
            'isian_tempat'                      => $request->isian_tempat,
            'isian_waktu'                       => $request->isian_waktu,
            'isian_deskripsi'                   => $request->isian_deskripsi,
            'isian_penilaiancara'               => $request->isian_penilaiancara,
            'isian_penilaianproses'             => $request->isian_penilaianproses,
            'isian_penilaiandeskripsi'          => $request->isian_penilaiandeskripsi,
            'isian_analisiscara'                => $request->isian_analisiscara,
            'isian_analisisdiagnostik'          => $request->isian_analisisdiagnostik,
            'isian_analisisprognosis'           => $request->isian_analisisprognosis,
            'isian_analisisdeskripsi'           => $request->isian_analisisdeskripsi,
            'isian_tindaklanjutcara'            => $request->isian_tindaklanjutcara,
            'isian_tindaklanjutdeskripsi'       => $request->isian_tindaklanjutdeskripsi,
        ];
        $this->mHomevisitEvaluasi->create($dataHomevisitEvaluasi);
        $dataStatus = [
            'status'    => 3 // update semua statusya jadi 0
        ];
        // cari yang statusnya 1, terus semua diupdate jadi 0
        // dd($dataHomevisitTu); die();
        $this->mHomevisitKegiatan->where('id', $id)->update($dataStatus);
        return redirect("$this->url2")->with('sukses', 'Data Homevisit Evaluasi berhasil di tambahkan');
        // dd($dataHomevisitEvaluasi);
    }
    
    public function download(Request $request)
    {
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $homevisit_evaluasi = $this->mHomevisitEvaluasi->where('id', $request->id)->first();
        // dd($mundur);
        
        $dataAlihRpl = [
            'KopSurat'                          => $sekolah->logo,
            'namakepsek'                        => $homevisit_evaluasi->kepsek->guru->nama ?? 'Kepsek belum di SET',
            'nipkepsek'                         => $homevisit_evaluasi->kepsek->guru->nip ?? 'Kepsek belum di SET',
            'namaKonselor'                      => $homevisit_evaluasi->konselor->guru->nama ?? 'Guru Konseling belum di SET',
            'nipKonselor'                       => $homevisit_evaluasi->konselor->guru->nip ?? 'Guru Konseling belum di SET',
            'surat_tempat'                      => $homevisit_evaluasi->surat_tempat,
            'surat_waktu'                       => $homevisit_evaluasi->surat_waktu,
            'isian_topik'                       => $homevisit_evaluasi->isian_topik,
            'isian_bidang'                      => $homevisit_evaluasi->isian_bidang,
            'isian_jenis'                       => $homevisit_evaluasi->isian_jenis,
            'isian_fungsi'                      => $homevisit_evaluasi->isian_fungsi,
            'isian_sasaran'                     => $homevisit_evaluasi->isian_sasaran,
            'isian_kompetensi'                  => $homevisit_evaluasi->isian_kompetensi,
            'isian_tempat'                      => $homevisit_evaluasi->isian_tempat,
            'isian_waktu'                       => $homevisit_evaluasi->isian_waktu,
            'isian_deskripsi'                   => $homevisit_evaluasi->isian_deskripsi,
            'isian_penilaiancara'               => $homevisit_evaluasi->isian_penilaiancara,
            'isian_penilaianproses'             => $homevisit_evaluasi->isian_penilaianproses,
            'isian_penilaiandeskripsi'          => $homevisit_evaluasi->isian_penilaiandeskripsi,
            'isian_analisiscara'                => $homevisit_evaluasi->isian_analisiscara,
            'isian_analisisdiagnostik'          => $homevisit_evaluasi->isian_analisisdiagnostik,
            'isian_analisisprognosis'           => $homevisit_evaluasi->isian_analisisprognosis,
            'isian_analisisdeskripsi'           => $homevisit_evaluasi->isian_analisisdeskripsi,
            'isian_tindaklanjutcara'            => $homevisit_evaluasi->isian_tindaklanjutcara,
            'isian_tindaklanjutdeskripsi'       => $homevisit_evaluasi->isian_tindaklanjutdeskripsi,
        ];
        $templateProcessor = new TemplateProcessor('word-template/home_visit/homevisit_evaluasi.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$dataAlihRpl['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('namaKepsek', $dataAlihRpl['namakepsek']); 
        $templateProcessor->setValue('nipKepsek', $dataAlihRpl['nipkepsek']); 
        $templateProcessor->setValue('namaKonselor', $dataAlihRpl['namaKonselor']); 
        $templateProcessor->setValue('nipKonselor', $dataAlihRpl['nipKonselor']);
        $templateProcessor->setValue('surat_tempat', $dataAlihRpl['surat_tempat']);
        $templateProcessor->setValue('surat_waktu', $dataAlihRpl['surat_waktu']);
        $templateProcessor->setValue('isian_topik', $dataAlihRpl['isian_topik']);
        $templateProcessor->setValue('isian_bidang', $dataAlihRpl['isian_bidang']);
        $templateProcessor->setValue('isian_jenis', $dataAlihRpl['isian_jenis']);
        $templateProcessor->setValue('isian_fungsi', $dataAlihRpl['isian_fungsi']);
        $templateProcessor->setValue('isian_sasaran', $dataAlihRpl['isian_sasaran']);
        $templateProcessor->setValue('isian_kompetensi', $dataAlihRpl['isian_kompetensi']);
        $templateProcessor->setValue('isian_tempat', $dataAlihRpl['isian_tempat']);
        $templateProcessor->setValue('isian_waktu', $dataAlihRpl['isian_waktu']);
        $templateProcessor->setValue('isian_deskripsi', $dataAlihRpl['isian_deskripsi']);
        $templateProcessor->setValue('isian_penilaiancara', $dataAlihRpl['isian_penilaiancara']);
        $templateProcessor->setValue('isian_penilaianproses', $dataAlihRpl['isian_penilaianproses']);
        $templateProcessor->setValue('isian_penilaiandeskripsi', $dataAlihRpl['isian_penilaiandeskripsi']);
        $templateProcessor->setValue('isian_analisiscara', $dataAlihRpl['isian_analisiscara']); 
        $templateProcessor->setValue('isian_analisisdiagnostik', $dataAlihRpl['isian_analisisdiagnostik']);
        $templateProcessor->setValue('isian_analisisprognosis', $dataAlihRpl['isian_analisisprognosis']);
        $templateProcessor->setValue('isian_analisisdeskripsi', $dataAlihRpl['isian_analisisdeskripsi']);
        $templateProcessor->setValue('isian_tindaklanjutcara', $dataAlihRpl['isian_tindaklanjutcara']);
        $templateProcessor->setValue('isian_tindaklanjutdeskripsi', $dataAlihRpl['isian_tindaklanjutdeskripsi']);
        $fileName = 'LAPORAN PELAKSANAAN DAN EVALUASI (PENILAIAN) ANALISIS DAN TINDAK LANJUT LAYANAN BIMBINGAN KONSELING'; // nama filenya
        

        // biar bisa dunlud
        $templateProcessor->saveAs('tempor/' . $fileName . '.docx');
        return response()->download('tempor/' . $fileName . '.docx')->deleteFileAfterSend(true);
        // dd($dataTartib);
    }
}
