<?php

namespace App\Http\Controllers\Admin\Layanan\FormIjin;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;

use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruPiketModel;

use App\Models\Siswa\SiswaModel;

use App\Models\Layanan\FormIjin\FormIjinKeluarModel;

use PhpOffice\PhpWord\TemplateProcessor;

class IjinKeluarController extends Controller
{
    private $views      = 'admin/layanan/form_ijin/ijin_keluar';
    private $url        = 'admin/layanan/form-ijin/keluar';
    private $title      = 'Halaman Form Ijin Keluar';


public function __construct()
    {
        createLogActivity();
        $this->mPeriode         = New PeriodeModel();

        $this->mPerpusSekolah   = new SekolahModel();

        $this->mKonselor        = New KonselorModel();
        $this->mPiket           = New GuruPiketModel();

        $this->mSiswa           = New SiswaModel();

        $this->mIjinKeluar      = New FormIjinKeluarModel();
    }

    public function index()
    {
        
        $ijinKeluar = $this->mIjinKeluar->where('idPSekolah', session()->get('idPSekolah'))->get();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Ijin Keluar',
            'ijinKeluar'    => $ijinKeluar,
        ];
        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $periode    = $this->mPeriode->get();
        $konselor   = $this->mKonselor->where('idPSekolah', session()->get('idPSekolah'))->get();

        $where = [
            'status' => 1,
            'idPSekolah' => session()->get('idPSekolah'),
        ];
        $piket      = $this->mPiket->where($where)->get();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Permintaan Surat Ijin',
            'periode'       => $periode,
            'gurukonselor'  => $konselor,
            'piket'         => $piket,
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $suratWaktu = $request->surat_waktu;  
        $suratWaktunew = date("d-m-Y", strtotime($suratWaktu));  
        
        $siswa = $this->mSiswa->where('id', $request->idSiswa)->first();
        $whereKons = [
            'id'            => $siswa['idSKonselor'],
            'status'        => 1,
        ];
        $konselor   = $this->mKonselor->where($whereKons)->first();
        if(!isset($konselor)){

            return redirect("$this->url")->with('gagal', 'Guru Konseling belum di set atau tidak aktif');
        };
        
        $dataIjinKeluar = [
            'idPSekolah'            => session()->get('idPSekolah'),
            'idPKKode'              => $request->idPKKode,
            'idPPeriode'            => session()->get('idPPeriode'),
            'idSiswa'               => $request->idSiswa,
            'idSKonselor'           => $konselor['id'],
            'idSPiket'              => $request->idSPiket,
            'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_yth'             => $request->isian_yth,
            'isian_pukul'           => $request->isian_pukul,
            'isian_keterangan'      => $request->isian_keterangan,
            'nomor'                 => $request->nomor,
        ];
        $this->mIjinKeluar->create($dataIjinKeluar);

        $ijinKeluar = $this->mIjinKeluar->where('kode_unik', $dataIjinKeluar['kode_unik'])->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Ijin Keluar',
            'ijinKeluar'    => $ijinKeluar,
        ];
        return view($this->views . "/show", $data);
    }

    public function show($id)
    {
        $ijinKeluar = $this->mIjinKeluar->where('kode_unik', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Ijin Keluar',
            'ijinKeluar'    => $ijinKeluar,
        ];
        return view($this->views . "/show", $data);
    }

    public function download($id)
    {
        if (!cekKopSurat(session()->get('idPSekolah'))) {
            return redirect("admin/dashboard")->with('gagal', 'Kop Surat tidak ditemukan, mohon upload ulang melalui login Admin Sekolah');
        }
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $ijinKeluar = $this->mIjinKeluar->where('kode_unik', $id)->first();
        $dataIjinKeluar = [
            'KopSurat'          => $sekolah->logo,
            'idPKKode'          => $ijinKeluar->kelaskode->kelas->nama.' '.$ijinKeluar->kelaskode->kelas->jurusan->nama.' '.$ijinKeluar->kelaskode->nama,
            'idSiswa'           => $ijinKeluar->siswa->nama,
            'nisSiswa'          => $ijinKeluar->siswa->nisn,
            'nomor'             => $ijinKeluar->nomor,
            'idSKonselor'       => $ijinKeluar->konselor->guru->nama ?? 'Guru Konseling belum di SET',
            'nipKonselor'       => $ijinKeluar->konselor->guru->nip ?? 'Guru Konseling belum di SET',
            'idSPiket'          => $ijinKeluar->piket->guru->nama ?? 'Guru Piket belum di SET',
            'nipPiket'          => $ijinKeluar->piket->guru->nip ?? 'Guru Piket belum di SET',
            'surat_tempat'      => $ijinKeluar->surat_tempat,
            'surat_waktu'       => $ijinKeluar->surat_waktu, // tanggal surat
            'isian_yth'         => $ijinKeluar->isian_yth,
            'isian_pukul'       => $ijinKeluar->isian_pukul,
            'isian_keterangan'  => $ijinKeluar->isian_keterangan,
        ];
        // pakai dari sini. sambil buka word coba.docx
        $templateProcessor = new TemplateProcessor('word-template/form_ijin/form_ijin_keluar.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$dataIjinKeluar['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('noSurat', $dataIjinKeluar['nomor']);
        $templateProcessor->setValue('kelasSiswa', $dataIjinKeluar['idPKKode']); 
        $templateProcessor->setValue('namaSiswa', $dataIjinKeluar['idSiswa']); 
        $templateProcessor->setValue('nisSiswa', $dataIjinKeluar['nisSiswa']); 
        $templateProcessor->setValue('namaKonselor', $dataIjinKeluar['idSKonselor']);
        $templateProcessor->setValue('nipKonselor', $dataIjinKeluar['nipKonselor']); 
        $templateProcessor->setValue('namaPiket', $dataIjinKeluar['idSPiket']);
        $templateProcessor->setValue('nipPiket', $dataIjinKeluar['nipPiket']); 
        $templateProcessor->setValue('surat_tempat', $dataIjinKeluar['surat_tempat']); 
        $templateProcessor->setValue('tanggalSurat', $dataIjinKeluar['surat_waktu']);
        $templateProcessor->setValue('isian_yth', $dataIjinKeluar['isian_yth']); 
        $templateProcessor->setValue('pukul', $dataIjinKeluar['isian_pukul']); 
        $templateProcessor->setValue('ket', $dataIjinKeluar['isian_keterangan']);
        $fileName = 'form_ijin_keluar'; // nama filenya
        
        // biar bisa dunlud
        $templateProcessor->saveAs('tempor/' . $fileName . '.docx');
        return response()->download('tempor/' . $fileName . '.docx')->deleteFileAfterSend(true);
        // dd($dataIjinKeluar); 
    }

    public function edit($id){
        $ijinKeluar = $this->mIjinKeluar->where('kode_unik', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Ijin Keluar',
            'ijinKeluar'     => $ijinKeluar,
        ];

        return view($this->views . "/edit", $data);

    }

    public function update(Request $request, $id)
    {
        $dataUbah = $this->mIjinKeluar->where('kode_unik', $id)->first();

        if (isset($request->surat_waktu)) {
            $suratWaktu     = $request->surat_waktu;
            $suratWaktunew  = date("d-m-Y", strtotime($suratWaktu));
        } else {
            $suratWaktunew     = $dataUbah->surat_waktu;  
        }

        $dataIjinKeluar = [
            // yang dicomment yang tidak berubah ya
            // 'idPSekolah'            => session()->get('idPSekolah'),
            // 'idPKKode'              => $request->idPKKode,
            // 'idPPeriode'            => session()->get('idPPeriode'),
            // 'idSiswa'               => $request->idSiswa,
            // 'idSKepsek'             => $kepsek['id'],
            // 'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'isian_yth'             => $request->isian_yth,
            'isian_pukul'           => $request->isian_pukul,
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_keterangan'      => $request->isian_keterangan,
        ];
        // echo json_encode($dataIjinKeluar); die;
        $this->mIjinKeluar->where('kode_unik', $id)->update($dataIjinKeluar);

        return redirect("$this->url")->with('sukses', 'Data Surat Ijin Keluar untuk '.$dataUbah->siswa->nama.' berhasil di edit');
    }

    public function destroy($id)
    {
        $this->mIjinKeluar->where('kode_unik', $id)->delete();

        return redirect("$this->url")->with('sukses', 'Data Surat Ijin Keluar berhasil di hapus');
    }
}
