<?php

namespace App\Http\Controllers\Admin\Import;

use App\Http\Controllers\Controller;
use App\Jobs\ImportDataJob;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\Import\DapodikGuruModel;
use App\Models\Import\DapodikSiswaModel;

use App\Models\User\UserModel;
use App\Models\Stakeholder\GuruModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Perpus\SekolahModel;
use Illuminate\Support\Facades\Log;

class MigrasiDapodikController extends Controller
{
      public function migrasiGuru(Request $request)
      {
            $dataJob = [];
            $dataJob['jenis'] = 'migrasiDapodikGuru';
            $dataJob['idPSekolah'] = session()->get('idPSekolah');
            $dataJob['idPPeriode'] = session()->get('idPPeriode');

            ImportDataJob::dispatch($dataJob);
      }

      public function migrasiSiswa(Request $request)
      {
            $dataJob = [];
            $dataJob['jenis'] = 'migrasiDapodikSiswa';
            $dataJob['idPSekolah'] = session()->get('idPSekolah');
            $dataJob['idPPeriode'] = session()->get('idPPeriode');

            ImportDataJob::dispatch($dataJob);
      }
}
