<?php

namespace App\Http\Controllers\Admin\Import;

use App\Http\Controllers\Controller;
use App\Imports\ImportDapodikGuru;
use App\Jobs\ImportDataJob;
use Illuminate\Http\Request;


// use App\Imports\LulusanImport;
// use App\Exports\LulusanExport;
use Maatwebsite\Excel\Facades\Excel;

// Panggil Nama file Model yang mau dipake
use App\Models\ImportDapodik\ImportexcelGuruModel;
use App\Models\ImportDapodik\ImportDapodikGuruModel;
use App\Models\ImportDapodik\ImportExcelSiswaModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Master\PeriodeModel;
use App\Models\Stakeholder\GuruModel;
use App\Models\Perpus\SekolahModel;
use Illuminate\Support\Facades\DB;

class ImportSiswaDapodikController extends Controller
{
      private $views      = 'admin/importdapodik/importStudent';
      private $url        = 'admin/import-dapodik/siswa';
      private $title      = 'Halaman Import Siswa';

      public function __construct()
      {
            $this->mExcelSiswa       = new ImportExcelSiswaModel();
      }

      public function index()
      {
            $excelSiswa     = $this->mExcelSiswa->where('idPSekolah', session()->get('idPSekolah'))->get();
            $data = [
                  'title'         => $this->title,
                  'url'           => $this->url,
                  'page'          => 'Data Import Siswa',
                  'excelSiswa'     => $excelSiswa
            ];

            return view($this->views . "/index", $data);
      }

      public function create()
      {
            $data = [
                  'title'         => $this->title,
                  'url'           => $this->url,
                  'page'          => 'Import Excel Siswa',
            ];

            return view($this->views . "/create", $data);
      }

      public function store(Request $request)
      {
            $validateData = $request->validate([
                  'file_excel'                    => 'required|mimes:csv,xls,xlsx'
            ], [
                  'file_excel.required'           => 'Pilih file terlebih dahulu',
                  'file_excel.mimes'              => 'Format data harus csv, xls atau xlsx',
            ]);

            $fileSave = $request->file('file_excel')->store('imports');
            $filePath = storage_path('app/' . $fileSave);
            $dataJob = [];
            $dataJob['jenis']       = 'importSiswa';
            $dataJob['file_path']   = $filePath;

            // Setting Siswa
            $idPKKode           = $request->kelasKode;
            $idMStatus          = 1; // Langsung aktif
            $idPPKelas          = 1; // Langsung Sesuai Periode Sekarang
            $idPPStatus         = 1; // Langsung Sesuai Periode Sekarang

            $dataJob['idUser']        = session()->get('users_id');
            $dataJob['idPSekolah']    = session()->get('idPSekolah');
            $dataJob['idPPeriode']    = session()->get('idPPeriode');
            $dataJob['idPKKode']      = $idPKKode;
            $dataJob['idMStatus']     = $idMStatus;
            $dataJob['idPPKelas']     = $idPPKelas;
            $dataJob['idPPStatus']    = $idPPStatus;

            ImportDataJob::dispatch($dataJob);

            $pesan = "Berhasil import";
            return redirect("$this->url")->with('sukses', $pesan);
      }
}
