<?php

namespace App\Http\Controllers\Admin\Import;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

use Maatwebsite\Excel\Facades\Excel;

// Panggil Nama file Model yang mau dipake
use App\Models\Import\ImportExcelSekolahModel;

use App\Models\Master\PeriodeModel;
use App\Models\Master\DaerahModel;
use App\Models\Master\ProvinsiModel;
use App\Models\Perpus\SekolahModel;
use App\Models\User\UserModel;

class ImportSekolahController extends Controller
{
    private $views      = 'admin/import/importSekolah';
    private $url        = 'admin/import-sekolah';
    private $title      = 'Halaman Import Sekolah';


public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mExcelSekolah          = new ImportExcelSekolahModel();
        $this->mPerpusSekolah         = new SekolahModel();
        $this->mPeriode               = new PeriodeModel();
        $this->mDaerah                = new DaerahModel();
        $this->mProvinsi              = new ProvinsiModel();
        $this->mUsers                 = new UserModel();
    }

    public function index()
    {
        // $guru = $this->mGuru->get();
        $excelSekolah     = $this->mExcelSekolah->get();

        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'page'              => 'Data Import Sekolah',
            'excelSekolah'      => $excelSekolah,
        ];
        
        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $daerah      = $this->mDaerah->get();
        $provinsi  = $this->mProvinsi->get();
        $periode    = $this->mPeriode->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Import Excel Sekolah',
            'daerah'        => $daerah,
            'provinsi'      => $provinsi,
            'periode'       => $periode,
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        // validasi
        $validateData = $request->validate([
            'file_excel'                    => 'required|mimes:csv,xls,xlsx'
        ],[
            'file_excel.required'           => 'Pilih file terlebih dahulu',
            'file_excel.mimes'              => 'Format data harus csv, xls atau xlsx',
        ]);

        // Library Import Excel
		$file = $validateData['file_excel'];
        $collection = Excel::toCollection(collect([]), $file); // ke convert collection

        $status=0; $exist=0; $berhasil=0;
        foreach ($collection[0] as $row) {
            // skip header

            $i=0;
            if($i <> 1) {
            
                if ($row[0] == 'id daerah') //buat skip row pertama
                    continue;

                // ambil dari excel
                $idMDaerah          = desc($row[0]);
                $idPPeriode         = desc($row[1]);
                $npsn               = $row[2];
                $nama               = $row[3];
                $alamat             = $row[4];
                $telp               = $row[5];
                $web                = $row[6];
                $email              = $row[7];

                $ada = $this->mPerpusSekolah->where('npsn', $npsn)->first();
                if($ada){
                    $status = 0; $exist++;
                }else{
                    $status = 1; $berhasil++;
                    $dataPerpusSekolah = [
                        'idMDaerah'     => $idMDaerah,
                        'idPPeriode'    => $idPPeriode,
                        'nama'          => $nama,
                        'alamat'        => $alamat,
                        'telp'          => $telp,
                        'web'           => $web,
                        'email'         => $email,
                        'npsn'          => $npsn,
                    ];
                    $perpus_sekolah = $this->mPerpusSekolah->create($dataPerpusSekolah);
    
                    // tambah mutasi
                    $dataUser = [
                        'username'          => $npsn,
                        'password'          => Hash::make('katasandi'),
                        'sandi'             => 'katasandi',
                        'role'              => 2,
                        'status'            => 2,
                        'idPSekolah'        => $perpus_sekolah['id'],
                        'idPPeriode'        => $idPPeriode,
                    ];
                    $this->mUsers->create($dataUser);
                }

                $recordImport = [
                    'idMDaerah'     => $idMDaerah,
                    'idPPeriode'    => $idPPeriode,
                    'npsn'          => $npsn,
                    'nama'          => $nama,
                    'alamat'        => $alamat,
                    'telp'          => $telp,
                    'status'        => $status
                ];
                $this->mExcelSekolah->create($recordImport);

            }
            $i++;
        }

        // $guru = $this->mGuru->get();
        $excelSekolah     = $this->mExcelSekolah->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Import Sekolah',
            'excelSekolah'  => $excelSekolah,
        ];
        return redirect("$this->url")->with('sukses', 'Berhasil di import: '.$berhasil.' | Gagal di import: '.$exist);
    }
}
