<?php

namespace App\Http\Controllers\Admin\Event;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Str;

use App\Models\Event\EventModel;
use App\Models\Log\LogEventModel;

class EventController extends Controller
{
    private $views      = 'admin/event';
    private $url        = 'admin/event';
    private $title      = 'Halaman Event';

    public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mEvent       = New EventModel();
        $this->mEventLog    = New LogEventModel();
    }

    public function index()
    {
        if(session()->get('role') == 1){
            $event = $this->mEvent->whereNot('status',3)->get();
        }else if(session()->get('role') == 2){
            $event = $this->mEvent->where('idPSekolah', session()->get('idPSekolah'))->get();
        }

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data List Event',
            'event'         => $event
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Event',
        ];
        
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $validateData = $request->validate([
            'image'                 => 'required|mimes:jpg,jpeg,png',
            'title'                 => 'required',
            'daterange2'                  => 'required',
            // 'date_start'            => 'required',
            // 'date_end'              => 'required',
            'location'              => 'required',
            'description'           => 'required',
        ],[
            'image.required'        => 'Pilih file terlebih dahulu',
            'image.mimes'           => 'Format data harus jpg, jpeg, atau png',
            'title.required'        => 'Isi Judul terlebih dahulu',
            'daterange2.required'   => 'Isi Tanggal dimulai terlebih dahulu',
            // 'date_start.required'   => 'Isi Tanggal dimulai terlebih dahulu',
            // 'date_end.required'     => 'Isi Tanggal diakhiri terlebih dahulu',
            'location.required'     => 'Isi Lokasi terlebih dahulu',
            'description.required'  => 'Isi Deskripsi terlebih dahulu',
        ]);

        if (isset($request->image)) {
            if ($request->hasFile('image')) {
                $file       = $request->file('image');
                $fileName   = Str::uuid()."-".time().".".$file->extension();
                $file->move( "upload/image_event/", $fileName);

                $logGambarEvent = [
                    'idUser'    => session()->get('users_id'),
                    'img'       => $fileName
                ];
                $this->mEventLog->create($logGambarEvent);
            }
        }

        $dataEvent = [
            'idUser'        => session()->get('users_id'),
            'idPSekolah'    => session()->get('idPSekolah'),
            'status'        => 1, // 1: waiting approval. 2: approve. 3: deactive. 4: need revision
            'image'         => $fileName,
            'title'         => $request->title,
            'date'          => $request->daterange2,
            // 'date_start'    => $request->date_start,
            // 'date_end'      => $request->date_end,
            'location'      => $request->location,
            'description'   => $request->description,
        ];
        $this->mEvent->create($dataEvent);

        return redirect("$this->url")->with('sukses', 'Event berhasil di tambahkan');
    }

    public function show($id)
    {
        $event = $this->mEvent->where('id', $id)->first();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data List Event',
            'event'         => $event
        ];

        return view($this->views . "/show", $data);
    }

    public function edit($id)
    {
        // Get Data
        $event          = $this->mEvent->where('id', $id)->first();
        
        if(!isset($event)){
            return redirect("$this->url")->with('gagal', 'Data Event tidak ditemukan');
        }

        $data = [
            'title'     => $this->title,
            'url'       => $this->url,
            'page'      => 'Edit Data Event',
            'event'     => $event,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        $event          = $this->mEvent->where('id', $id)->first();

        if(!isset($event)){
            return redirect("$this->url")->with('gagal', 'Data Event tidak ditemukan');
        }

        $validateData = $request->validate([
            'image'                    => 'mimes:jpg,jpeg,png',
        ],[
            'image.mimes'             => 'Format data harus jpg, jpeg, atau png',
        ]);

        if (isset($request->image)) {
            if ($request->hasFile('image')) {
                $file       = $request->file('image');
                $fileName   = Str::uuid()."-".time().".".$file->extension();
                $file->move( "upload/image_event/", $fileName);

                $logGambarEvent = [
                    'idUser'    => session()->get('users_id'),
                    'img'       => $fileName
                ];
                $this->mEventLog->create($logGambarEvent);
            }
        }

        $dataEvent = [
            'idUser'        => session()->get('users_id'),
            'idPSekolah'    => session()->get('idPSekolah'),
            'status'        => 1, // 1: waiting approval. 2: approve. 3: deactive. 4: need revision
            'image'         => $fileName ?? $event->image,
            'title'         => $request->title ?? $event->title,
            'date'          => $request->daterange2 ?? $event->date,
            // 'date_start'    => $request->date_start ?? $event->date_start,
            // 'date_end'      => $request->date_end ?? $event->date_end,
            'location'      => $request->location ?? $event->location,
            'description'   => $request->description ?? $event->description,
        ];
        $this->mEvent->where('id', $id)->update($dataEvent);

        return redirect("$this->url")->with('sukses', 'Data Event berhasil di edit, menunggu konfirmasi admin');
    }

    public function deActive($id)
    {
        $event          = $this->mEvent->where('id', $id)->first();

        if(!isset($event)){
            return redirect("$this->url")->with('gagal', 'Data Event tidak ditemukan');
        }

        if($event->status == 3){
            return redirect("$this->url")->with('gagal', 'Data Event memang tidak aktif');
        }

        $dataEvent = [
            'status'        => 3, // 1: waiting approval. 2: approve. 3: deactive. 4: need revision
        ];
        $this->mEvent->where('id', $id)->update($dataEvent);

        return redirect("$this->url")->with('sukses', 'Data Event berhasil di non-Aktifkan');
    }

    public function activing($id)
    {
        $event          = $this->mEvent->where('id', $id)->first();

        if(!isset($event)){
            return redirect("$this->url")->with('gagal', 'Data Event tidak ditemukan');
        }

        if($event->status == 3){
            $dataEvent = [
                'status'        => 1, // 1: waiting approval. 2: approve. 3: deactive. 4: need revision
            ];
            $this->mEvent->where('id', $id)->update($dataEvent);
        }else{
            return redirect("$this->url")->with('gagal', 'Data Event sudah aktif');
        }


        return redirect("$this->url")->with('sukses', 'Data Event berhasil di Aktifkan, menunggu konfirmasi admin');
    }

    public function confirm(Request $request, $id)
    {
        $event          = $this->mEvent->where('id', $id)->first();
        
        if(!isset($event)){
            return redirect("$this->url")->with('gagal', 'Data Event tidak ditemukan');
        }

        if($event->status == 2){
            return redirect("$this->url")->with('gagal', 'Data Event memang ter-konfirmasi');
        }

        $dataEvent = [
            'status'        => 2, // 1: waiting approval. 2: approve. 3: deactive. 4: need revision
        ];
        $this->mEvent->where('id', $id)->update($dataEvent);

        return redirect("$this->url")->with('sukses', 'Status Data Event berhasil di rubah');
    }

    public function rejectConfirm(Request $request, $id)
    {
        $event          = $this->mEvent->where('id', $id)->first();
        
        if(!isset($event)){
            return redirect("$this->url")->with('gagal', 'Data Event tidak ditemukan');
        }

        if($event->status != 1){
            return redirect("$this->url")->with('gagal', 'Data Event memang butuh revisi');
        }

        $dataEvent = [
            'status'        => 4, // 1: waiting approval. 2: approve. 3: deactive. 4: need revision
        ];
        $this->mEvent->where('id', $id)->update($dataEvent);

        return redirect("$this->url")->with('sukses', 'Status Data Event berhasil di rubah');
    }

    public function deConfirm(Request $request, $id)
    {
        $validateData = $request->validate([
            'status'                    => 'required',
        ],[
            'status.required'             => 'Isian Status perlu dipilih',
        ]);

        $event          = $this->mEvent->where('id', $id)->first();
        
        if(!isset($event)){
            return redirect("$this->url")->with('gagal', 'Data Event tidak ditemukan');
        }

        if($event->status != 2){
            return redirect("$this->url")->with('gagal', 'Data Event memang butuh revisi');
        }

        $dataEvent = [
            'status'        => 4, // 1: waiting approval. 2: approve. 3: deactive. 4: need revision
        ];
        $this->mEvent->where('id', $id)->update($dataEvent);

        return redirect("$this->url")->with('sukses', 'Status Data Event berhasil di rubah');
    }

    public function delete($id)
    {
        $event          = $this->mEvent->where('id', $id)->first();
        if(!isset($event)){
            return redirect("$this->url")->with('gagal', 'Data Event tidak ditemukan');
        }

        $this->mEvent->where('id', $id)->delete();

        return redirect("$this->url")->with('sukses', 'Status Data Event berhasil di hapus');
    }
}
