<?php

use Illuminate\Support\Facades\Route;


Route::prefix('/admin/layanan/surat')->group(function () {
    Route::get('/daftar/pt', 'Admin\Layanan\Surat\SPDaftarPTController@index')->name('daftar.pt');
    Route::get('/daftar/pt/create', 'Admin\Layanan\Surat\SPDaftarPTController@create');
    Route::post('/daftar/pt/store', 'Admin\Layanan\Surat\SPDaftarPTController@store');
    Route::get('/daftar/pt/{dataId?}/edit', 'Admin\Layanan\Surat\SPDaftarPTController@edit');
    Route::get('/daftar/pt/{dataId?}/download', 'Admin\Layanan\Surat\SPDaftarPTController@download');
    Route::get('/daftar/pt/{dataId?}', 'Admin\Layanan\Surat\SPDaftarPTController@show');
    Route::put('/daftar/pt/update/{dataId?}', 'Admin\Layanan\Surat\SPDaftarPTController@update');
    Route::delete('/daftar/pt/delete/{dataId?}', 'Admin\Layanan\Surat\SPDaftarPTController@destroy');
    
    Route::get('/keterangan/dipulangkan', 'Admin\Layanan\Surat\SKDipulangkanController@index')->name('keterangan.dipulangkan');
    Route::get('/keterangan/dipulangkan/create', 'Admin\Layanan\Surat\SKDipulangkanController@create');
    Route::post('/keterangan/dipulangkan/store', 'Admin\Layanan\Surat\SKDipulangkanController@store');
    Route::get('/keterangan/dipulangkan/{dataId?}/edit', 'Admin\Layanan\Surat\SKDipulangkanController@edit');
    Route::get('/keterangan/dipulangkan/{dataId?}/download', 'Admin\Layanan\Surat\SKDipulangkanController@download');
    Route::get('/keterangan/dipulangkan/{dataId?}', 'Admin\Layanan\Surat\SKDipulangkanController@show');
    Route::put('/keterangan/dipulangkan/update/{dataId?}', 'Admin\Layanan\Surat\SKDipulangkanController@update');
    Route::delete('/keterangan/dipulangkan/delete/{dataId?}', 'Admin\Layanan\Surat\SKDipulangkanController@destroy');

    Route::get('/pernyataan/mundur', 'Admin\Layanan\Surat\SPMundurController@index')->name('pernyataan.mundur');
    Route::get('/pernyataan/mundur/create', 'Admin\Layanan\Surat\SPMundurController@create');
    Route::post('/pernyataan/mundur/store', 'Admin\Layanan\Surat\SPMundurController@store');
    Route::get('/pernyataan/mundur/{dataId?}/edit', 'Admin\Layanan\Surat\SPMundurController@edit');
    Route::get('/pernyataan/mundur/{dataId?}/download', 'Admin\Layanan\Surat\SPMundurController@download');
    Route::get('/pernyataan/mundur/{dataId?}', 'Admin\Layanan\Surat\SPMundurController@show');
    Route::put('/pernyataan/mundur/update/{dataId?}', 'Admin\Layanan\Surat\SPMundurController@update');
    Route::delete('/pernyataan/mundur/delete/{dataId?}', 'Admin\Layanan\Surat\SPMundurController@destroy');

    Route::get('/pernyataan/tartib', 'Admin\Layanan\Surat\SPTataTertibController@index')->name('pernyataan.tartib');
    Route::get('/pernyataan/tartib/create', 'Admin\Layanan\Surat\SPTataTertibController@create');
    Route::post('/pernyataan/tartib/store', 'Admin\Layanan\Surat\SPTataTertibController@store');
    Route::get('/pernyataan/tartib/{dataId?}/edit', 'Admin\Layanan\Surat\SPTataTertibController@edit');
    Route::get('/pernyataan/tartib/{dataId?}/download', 'Admin\Layanan\Surat\SPTataTertibController@download');
    Route::get('/pernyataan/tartib/{dataId?}', 'Admin\Layanan\Surat\SPTataTertibController@show');
    Route::put('/pernyataan/tartib/update/{dataId?}', 'Admin\Layanan\Surat\SPTataTertibController@update');
    Route::delete('/pernyataan/tartib/delete/{dataId?}', 'Admin\Layanan\Surat\SPTataTertibController@destroy');

    Route::get('/undangan/ortu', 'Admin\Layanan\Surat\SUndangOrtuController@index')->name('undangan.ortu');
    Route::get('/undangan/ortu/create', 'Admin\Layanan\Surat\SUndangOrtuController@create');
    Route::post('/undangan/ortu/store', 'Admin\Layanan\Surat\SUndangOrtuController@store');
    Route::get('/undangan/ortu/{dataId?}/edit', 'Admin\Layanan\Surat\SUndangOrtuController@edit');
    Route::get('/undangan/ortu/{dataId?}/download', 'Admin\Layanan\Surat\SUndangOrtuController@download');
    Route::get('/undangan/ortu/{dataId?}', 'Admin\Layanan\Surat\SUndangOrtuController@show');
    Route::put('/undangan/ortu/update/{dataId?}', 'Admin\Layanan\Surat\SUndangOrtuController@update');
    Route::delete('/undangan/ortu/delete/{dataId?}', 'Admin\Layanan\Surat\SUndangOrtuController@destroy');

});

Route::prefix('/admin/layanan/form-ijin')->group(function () {
    Route::get('/keluar', 'Admin\Layanan\FormIjin\IjinKeluarController@index')->name('keluar');
    Route::get('/keluar/create', 'Admin\Layanan\FormIjin\IjinKeluarController@create');
    Route::post('/keluar/store', 'Admin\Layanan\FormIjin\IjinKeluarController@store');
    Route::get('/keluar/{dataId?}/edit', 'Admin\Layanan\FormIjin\IjinKeluarController@edit');
    Route::get('/keluar/{dataId?}/download', 'Admin\Layanan\FormIjin\IjinKeluarController@download');
    Route::get('/keluar/{dataId?}', 'Admin\Layanan\FormIjin\IjinKeluarController@show');
    Route::put('/keluar/update/{dataId?}', 'Admin\Layanan\FormIjin\IjinKeluarController@update');
    Route::delete('/keluar/delete/{dataId?}', 'Admin\Layanan\FormIjin\IjinKeluarController@destroy');

    Route::get('/masuk/kelas', 'Admin\Layanan\FormIjin\IjinMasukController@index')->name('masuk.kelas');
    Route::get('/masuk/kelas/create', 'Admin\Layanan\FormIjin\IjinMasukController@create');
    Route::post('/masuk/kelas/store', 'Admin\Layanan\FormIjin\IjinMasukController@store');
    Route::get('/masuk/kelas/{dataId?}/edit', 'Admin\Layanan\FormIjin\IjinMasukController@edit');
    Route::get('/masuk/kelas/{dataId?}/download', 'Admin\Layanan\FormIjin\IjinMasukController@download');
    Route::get('/masuk/kelas/{dataId?}', 'Admin\Layanan\FormIjin\IjinMasukController@show');
    Route::put('/masuk/kelas/update/{dataId?}', 'Admin\Layanan\FormIjin\IjinMasukController@update');
    Route::delete('/masuk/kelas/delete/{dataId?}', 'Admin\Layanan\FormIjin\IjinMasukController@destroy');
});

Route::prefix('/admin/layanan/lainnya')->group(function () {

    // kegiatan + rpl -> pengantar
    Route::get('/alih-tangan/kegiatan', 'Admin\Layanan\Alihtangan\AlihtanganKegiatanController@index')->name('alih.tangan');
    Route::get('/alih-tangan/kegiatan/create', 'Admin\Layanan\Alihtangan\AlihtanganKegiatanController@create');
    Route::post('/alih-tangan/kegiatan/store', 'Admin\Layanan\Alihtangan\AlihtanganKegiatanController@store');
    Route::get('/alih-tangan/kegiatan/{dataId?}', 'Admin\Layanan\Alihtangan\AlihtanganKegiatanController@show');

    Route::get('/alih-tangan/rpl/{dataId?}', 'Admin\Layanan\Alihtangan\AlihtanganRplController@show');
    Route::get('/alih-tangan/rpl/{dataId?}/download', 'Admin\Layanan\Alihtangan\AlihtanganRplController@download');
    // Route::get('/alih-tangan/rpl/{dataId?}/edit', 'Admin\Layanan\Alihtangan\AlihtanganRplController@edit');
    // Route::delete('/alih-tangan/rpl/delete/{dataId?}', 'Admin\Layanan\Alihtangan\AlihtanganRplController@delete');

    Route::get('/alih-tangan/pengantar/create/{dataId?}', 'Admin\Layanan\Alihtangan\AlihtanganPengantarController@create');
    Route::post('/alih-tangan/pengantar/store/{dataId?}', 'Admin\Layanan\Alihtangan\AlihtanganPengantarController@store');
    Route::get('/alih-tangan/pengantar/{dataId?}', 'Admin\Layanan\Alihtangan\AlihtanganPengantarController@show');
    Route::post('/alih-tangan/pengantar/download', 'Admin\Layanan\Alihtangan\AlihtanganPengantarController@download');
    // Route::get('/alih-tangan/rpl/{dataId?}/edit', 'Admin\Layanan\Alihtangan\AlihtanganRplController@edit');
    // Route::delete('/alih-tangan/rpl/delete/{dataId?}', 'Admin\Layanan\Alihtangan\AlihtanganRplController@delete');

    Route::get('/konferensi/kegiatan', 'Admin\Layanan\Konferensi\KonferensiKegiatanController@index')->name('konferensi');
    Route::get('/konferensi/kegiatan/create', 'Admin\Layanan\Konferensi\KonferensiKegiatanController@create');
    Route::post('/konferensi/kegiatan/store', 'Admin\Layanan\Konferensi\KonferensiKegiatanController@store');
    Route::get('/konferensi/kegiatan/{dataId?}', 'Admin\Layanan\Konferensi\KonferensiKegiatanController@show');

    Route::get('/konferensi/rpl/{dataId?}', 'Admin\Layanan\Konferensi\KonferensiRPLController@show');
    Route::get('/konferensi/rpl/{dataId?}/download', 'Admin\Layanan\Konferensi\KonferensiRPLController@download');
    // Route::get('/alih-tangan/rpl/{dataId?}/edit', 'Admin\Layanan\Konferensi\KonferensiRPLController@edit');
    // Route::delete('/alih-tangan/rpl/delete/{dataId?}', 'Admin\Layanan\Konferensi\KonferensiRPLController@delete');

    Route::get('/konferensi/berita-acara/create/{dataId?}', 'Admin\Layanan\Konferensi\KonferensiBeritaAcaraController@create');
    Route::post('/konferensi/berita-acara/store/{dataId?}', 'Admin\Layanan\Konferensi\KonferensiBeritaAcaraController@store');
    Route::get('/konferensi/berita-acara/{dataId?}', 'Admin\Layanan\Konferensi\KonferensiBeritaAcaraController@show');
    Route::post('/konferensi/berita-acara/download', 'Admin\Layanan\Konferensi\KonferensiBeritaAcaraController@download');
    // Route::get('/alih-tangan/rpl/{dataId?}/edit', 'Admin\Layanan\Alihtangan\AlihtanganRplController@edit');
    // Route::delete('/alih-tangan/rpl/delete/{dataId?}', 'Admin\Layanan\Alihtangan\AlihtanganRplController@delete');

    // kegiatan + rpl -> tu -> evaluasi
    Route::get('/home/visit', 'Admin\Layanan\Homevisit\HomevisitKegiatanController@index')->name('home.visit');
    Route::get('/home/visit/create', 'Admin\Layanan\Homevisit\HomevisitKegiatanController@create');
    Route::post('/home/visit/store', 'Admin\Layanan\Homevisit\HomevisitKegiatanController@store');
    Route::get('/home/visit/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitKegiatanController@show');

    Route::get('/home/visit/rpl/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitRplController@show');
    Route::get('/home/visit/rpl/{dataId?}/download', 'Admin\Layanan\Homevisit\HomevisitRplController@download');
    // Route::get('/home/visit/rpl/{dataId?}/edit', 'Admin\Layanan\Homevisit\HomevisitRplController@edit');
    // Route::delete('/home/visit/rpl/delete/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitRplController@delete');
    
    Route::get('/home/visit/tu/create/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitTuController@create');
    Route::post('/home/visit/tu/store/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitTuController@store');
    Route::get('/home/visit/tu/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitTuController@show');
    Route::post('/home/visit/tu/download', 'Admin\Layanan\Homevisit\HomevisitTuController@download');
    // Route::get('/home/visit/tu/{dataId?}/edit', 'Admin\Layanan\Homevisit\HomevisitTuController@edit');
    // Route::delete('/home/visit/tu/delete/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitTuController@delete');
    
    Route::get('/home/visit/evaluasi/create/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitEvaluasiController@create');
    Route::post('/home/visit/evaluasi/store/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitEvaluasiController@store');
    Route::get('/home/visit/evaluasi/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitEvaluasiController@show');
    Route::post('/home/visit/evaluasi/download', 'Admin\Layanan\Homevisit\HomevisitEvaluasiController@download');
    // Route::get('/home/visit/evaluasi/{dataId?}/edit', 'Admin\Layanan\Homevisit\HomevisitEvaluasiController@edit');
    // Route::delete('/home/visit/evaluasi/delete/{dataId?}', 'Admin\Layanan\Homevisit\HomevisitEvaluasiController@delete');
});

Route::prefix('/admin/layanan/konseling')->group(function () {
    Route::get('/konseling', 'Admin\Layanan\Konseling\KonselingController@index')->name('konseling');
    Route::get('/konseling/create', 'Admin\Layanan\Konseling\KonselingController@create');
    Route::post('/konseling/store', 'Admin\Layanan\Konseling\KonselingController@store');
    Route::get('/konseling/{dataId?}', 'Admin\Layanan\Konseling\KonselingController@show');

    Route::get('/bimbingan', 'Admin\Layanan\Konseling\PembinaanController@index')->name('bimbingan');
    Route::get('/bimbingan/create', 'Admin\Layanan\Konseling\PembinaanController@create');
    Route::post('/bimbingan/store', 'Admin\Layanan\Konseling\PembinaanController@store');
    Route::get('/bimbingan/{dataId?}', 'Admin\Layanan\Konseling\PembinaanController@show');
});