<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', ('Landing\LandingController@index')); 
// Route::get('tentang', ('Landing\TentangController@index'));
Route::get('/', ('AuthController@login')); 
Route::get('/reload-captcha', ('AuthController@reloadCaptcha'));
Route::get('login', ('AuthController@login'));
Route::post('login-proses', ('AuthController@loginProses'));
Route::get('update-password', ('AuthController@updatePassword'))->name('password.change');
Route::post('update-proses', ('AuthController@updateProses'));
Route::get('register', ('AuthController@register'));
Route::post('register-proses', ('AuthController@registerProses'));
Route::get('logout', ('AuthController@logout'));

Route::get('admin/dashboard', 'Admin\DashboardController@index')->name('dashboard')->middleware(['login:1,2,3']);

Route::middleware(['login:1,2'])->group(function () {

    Route::get('/import-dapodik-guru', 'Admin\Import\ImportDapodikController@importDapodikGuru');
    Route::get('/import-dapodik-siswa', 'Admin\Import\ImportDapodikController@importDapodikSiswa');

    Route::prefix('admin/master/sekolah')->group(function () {

        Route::get('/info', 'Admin\Perpus\InfoController@index')->name('info');
        Route::get('/info/create', 'Admin\Perpus\InfoController@create');
        Route::post('/info/store', 'Admin\Perpus\InfoController@store');
        Route::get('/info/{dataId?}', 'Admin\Perpus\InfoController@show');
        Route::get('/info/{dataId?}/edit', 'Admin\Perpus\InfoController@edit');
        Route::put('/info/update/{dataId?}', 'Admin\Perpus\InfoController@update');
        Route::delete('/info/delete/{dataId?}', 'Admin\Perpus\InfoController@delete');

        Route::get('/jurusan', 'Admin\Perpus\JurusanController@index')->name('jurusan');
        Route::get('/jurusan/create', 'Admin\Perpus\JurusanController@create');
        Route::post('/jurusan/store', 'Admin\Perpus\JurusanController@store');
        Route::get('/jurusan/{dataId?}', 'Admin\Perpus\JurusanController@show');
        Route::get('/jurusan/{dataId?}/edit', 'Admin\Perpus\JurusanController@edit');
        Route::put('/jurusan/update/{dataId?}', 'Admin\Perpus\JurusanController@update');
        Route::delete('/jurusan/delete/{dataId?}', 'Admin\Perpus\JurusanController@delete');

        Route::get('/tingkat', 'Admin\Perpus\KelasController@index')->name('tingkat');
        Route::get('/tingkat/create', 'Admin\Perpus\KelasController@create');
        Route::post('/tingkat/store', 'Admin\Perpus\KelasController@store');
        Route::get('/tingkat/{dataId?}', 'Admin\Perpus\KelasController@show');
        Route::get('/tingkat/{dataId?}/edit', 'Admin\Perpus\KelasController@edit');
        Route::put('/tingkat/update/{dataId?}', 'Admin\Perpus\KelasController@update');
        Route::delete('/tingkat/delete/{dataId?}', 'Admin\Perpus\KelasController@delete');

        Route::get('/indeks-kelas', 'Admin\Perpus\KelasKodeController@index')->name('indeks-kelas');
        Route::get('/indeks-kelas/create', 'Admin\Perpus\KelasKodeController@create');
        Route::post('/indeks-kelas/store', 'Admin\Perpus\KelasKodeController@store');
        Route::post('/indeks-kelas/import', 'Admin\Perpus\KelasKodeController@import');
        Route::get('/indeks-kelas/{dataId?}', 'Admin\Perpus\KelasKodeController@show');
        Route::get('/indeks-kelas/{dataId?}/edit', 'Admin\Perpus\KelasKodeController@edit');
        Route::put('/indeks-kelas/update/{dataId?}', 'Admin\Perpus\KelasKodeController@update');
        Route::delete('/indeks-kelas/delete/{dataId?}', 'Admin\Perpus\KelasKodeController@delete');
    });

    Route::prefix('admin/siswa')->group(function () {
        
        Route::get('/ortu', 'Admin\Siswa\OrtuController@index')->name('ortu');
        Route::get('/ortu/create', 'Admin\Siswa\OrtuController@create');
        Route::post('/ortu/store', 'Admin\Siswa\OrtuController@store');
        Route::get('/ortu/{dataId?}/edit', 'Admin\Siswa\OrtuController@edit');
        Route::put('/ortu/update/{dataId?}', 'Admin\Siswa\OrtuController@update');
        Route::get('/ortu/{dataId?}', 'Admin\Siswa\OrtuController@show');
        
        Route::get('/', 'Admin\Siswa\SiswaController@index')->name('siswa');
        Route::get('/create/{dataId?}', 'Admin\Siswa\SiswaController@create');
        Route::post('/store', 'Admin\Siswa\SiswaController@store');
        Route::get('/{dataId?}/edit', 'Admin\Siswa\SiswaController@edit');
        Route::put('/update/{dataId?}', 'Admin\Siswa\SiswaController@update');
        Route::delete('/delete/{dataId?}', 'Admin\Siswa\SiswaController@delete');
        Route::get('/{dataId?}', 'Admin\Siswa\SiswaController@show');
    });

    Route::prefix('admin/event')->group(function () {
        
        Route::get('/', 'Admin\Event\EventController@index')->name('event');
        Route::get('/create/{dataId?}', 'Admin\Event\EventController@create');
        Route::post('/store', 'Admin\Event\EventController@store');
        Route::get('/{dataId?}/edit', 'Admin\Event\EventController@edit');
        Route::put('/update/{dataId?}', 'Admin\Event\EventController@update');
        Route::delete('/delete/{dataId?}', 'Admin\Event\EventController@delete');
        Route::get('/aktivasi/{dataId?}', 'Admin\Event\EventController@activing');
        Route::get('/de-aktif/{dataId?}', 'Admin\Event\EventController@deActive');
        Route::post('/confirm/{dataId?}', 'Admin\Event\EventController@confirm');
        Route::post('/reject-confirm/{dataId?}', 'Admin\Event\EventController@rejectConfirm');
        Route::post('/de-confirm/{dataId?}', 'Admin\Event\EventController@deConfirm');
        Route::get('/{dataId?}', 'Admin\Event\EventController@show');
    });

    // Route::get('/bantusandi/{dataId?}', 'Api\EnkripsiController@bantusandi');
});

Route::middleware(['login:1'])->group(function () {
    @include_once('web_admin.php');
});

Route::middleware(['login:2'])->group(function () {
    @include_once('web_sekolah.php');
});

Route::middleware(['login:3'])->group(function () {
    @include_once('web_konselor.php');
});

// API
Route::middleware(['login:1,2,3'])->group(function () {
    
    Route::prefix('/admin/saran')->group(function () {
        Route::get('/', 'Admin\Layanan\SaranAdminController@index')->name('admin.saran');
        Route::get('/create', 'Admin\Layanan\SaranAdminController@create');
        Route::post('/store', 'Admin\Layanan\SaranAdminController@store');
        Route::get('/{dataId?}/edit', 'Admin\Layanan\SaranAdminController@edit');
        Route::put('/update/{dataId?}', 'Admin\Layanan\SaranAdminController@update');
        Route::get('/{dataId?}', 'Admin\Layanan\SaranAdminController@show');
    });

    Route::prefix('/admin/akun')->group(function () {
        Route::get('/', 'Admin\AkunController@index')->name('admin.akun');
        Route::get('/update-password', 'Admin\AkunController@edit');
        Route::put('/update', 'Admin\AkunController@update');
    });

    // List master dan perpus
    Route::get('getAllProvinsi/', 'Api\DaerahController@getAllProvinsi');
    Route::get('getProvinsiDaerah/{idMprovinsi}', 'Api\DaerahController@getProvinsiDaerah');
    Route::get('getDaerahSekolah/{idMDaerah}', 'Api\DaerahController@getDaerahSekolah');
    Route::get('getJurusanSekolah/{idPSekolah}', 'Api\DaerahController@getJurusanSekolah');
    Route::get('getAngkatanSekolah/{idPJurusan}', 'Api\DaerahController@getAngkatanSekolah');
    Route::get('getKelasSekolah/{idAngkatan}', 'Api\DaerahController@getKelasSekolah');
    Route::get('getcKelasSekolah/{idAngkatan}', 'Api\DaerahController@getcKelasSekolah');
    
    Route::get('getAngkatanKomplit/{idPSekolah}', 'Api\DaerahController@getAngkatanKomplit');
    Route::get('getKelasKomplit/{idPSekolah}', 'Api\DaerahController@getKelasKomplit');

    // List Siswa
    Route::get('getSiswaKelas/{idAngkatan}', 'Api\SiswaController@getSiswaKelas');
    Route::get('getSiswaKonselorKelas/{idAngkatan}', 'Api\SiswaController@getSiswaKonselorKelas');
    Route::get('getSiswaKonselor', 'Api\SiswaController@getSiswaKonselor');

    // Tabel Sekolah
    Route::get('perpus/getTabelSekolahDaerah/{idMDaerah}', 'Api\TabelPerpusController@getSekolahDaerah');
    Route::get('perpus/getTabelSekolahJurusan/{idPSekolah}', 'Api\TabelPerpusController@getSekolahJurusan');
    Route::get('perpus/getTabelSekolahAngkatan/{idPJurusan}', 'Api\TabelPerpusController@getSekolahKelas');
    Route::get('perpus/getTabelSekolahKelas/{idPKelas}', 'Api\TabelPerpusController@getSekolahKelasKode');

    // Tabel Stakeholder
    Route::get('stakeholder/getTabelSekolahWali/{idAngkatan}', 'Api\TabelStakeholderController@getSekolahWali'); 

    // Tabel Siswa
    Route::get('siswa/getTabelSekolahSiswa/{idPKKode}', 'Api\TabelSiswaController@getSekolahSiswa');
    Route::get('siswa/getTabelPeriodeSiswa/{idAngkatan}', 'Api\TabelSiswaController@getPeriodeSiswa');
    Route::get('siswa/getSiswaKonseling/{idPKKode}', 'Api\TabelSiswaController@getSiswaKonseling'); 
    Route::get('siswa/getSiswaPembinaan/{idPKKode}', 'Api\TabelSiswaController@getSiswaPembinaan'); 
    // Route::any('sekolahtabelkhusus/getSekolahSiswaPembinaan/{idPKKode}', 'Api\SekolahTabelKhususController@getSekolahSiswaPembinaan');

});
// Chart Jenis sekolah
Route::get('getAllProvinsi/', 'Api\DaerahController@getAllProvinsi');
Route::get('getProvinsiDaerah/{idMprovinsi}', 'Api\DaerahController@getProvinsiDaerah');
Route::get('chart/jenis-sekolah/getChartJmlSekolah/', 'Api\ChartJenisSekolahController@getChartJmlSekolah');
Route::get('chart/jenis-sekolah/getChartJmlSiswa/', 'Api\ChartJenisSekolahController@getChartJmlSiswa');
Route::get('event/get-all/', 'Api\EventController@getAllEvent');
