@extends($landing)

@section('css-library')
    {{-- Tempat Ngoding Meletakkan css library --}}
@endsection

@section('css-custom')
    {{-- Tempat Ngoding Meletakkan css custom --}}
@endsection

@section('content')

    <!--====== PAGE BANNER PART START ======-->
    
    <section id="page-banner" class="pt-105 pb-110 bg_cover" data-overlay="8" style="background-image: url(assets/landing/images/bg.jpeg)">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="page-banner-cont">
                        <h2>{{ $page }}</h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ url('') }}">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">{{ $page }}</li>
                            </ol>
                        </nav>
                    </div>  <!-- page banner cont -->
                </div>
            </div> <!-- row -->
        </div> <!-- container -->
    </section>
    
    <!--====== PAGE BANNER PART ENDS ======-->
   
    <!--====== ABOUT PART START ======-->
    
    <section id="about-page" class="pt-70 pb-110">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="section-title mt-50">
                        <h5>Tentang Sistem</h5>
                        <h2>Apa itu Sistem Layanan Guru Konseling?</h2>
                    </div> <!-- section title -->
                    <div class="about-cont">
                        <p>Sistem Layanan Guru BK atau yang sekarang disebut dengan Guru Konseling yaitu sistem yang dibuat untuk mempermudah serta mengembangkan pekerjaan guru Konseling secara Digital. Guru Konseling dapat melakukan pendataan dari siswa yang diampu, melakukan konseling serta pembinaan terhadap siswa secara online</p>
                        <p>Sistem Layanan Guru Konseling ini merupakan kerjasama antara Universitas Dian Nuswantoro dengan guru-guru Konseling SMA, SMK dan MA se-Provinsi Jawa Tengah untuk mendigitalisasi sistem kerja guru Konseling</p>
                    </div> <!-- about cont -->
                </div>
                <div class="col-lg-6 offset-lg-1 col-11 offset-1">
                    <div class="about-image-tow mt-55">
                        <img src="{{ asset('assets/landing/images/about/about-2.jpg') }}" alt="about">
                        <div class="about-shape-tow">
                            <img src="{{ asset('assets/landing/images/about/shape-2.png') }}" alt="shape">
                        </div>
                        <div class="about-shape-three">
                            <img src="{{ asset('assets/landing/images/about/shape-3.png') }}" alt="shape">
                        </div>
                    </div> <!-- about image tow -->
                </div>
            </div> <!-- row -->
        </div> <!-- container -->
    </section>
    
    <!--====== ABOUT PART ENDS ======-->

    <!--====== COUNTER PART START ======-->
    
    <div id="counter-part" class="bg_cover pt-65 pb-110" data-overlay="8" style="background-image: url(assets/landing/images/bg-2.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-sm-6">
                    <div class="single-counter text-center mt-40">
                        <span><span class="counter">503</span></span>
                        <p>SMA/MA Negeri</p>
                    </div> <!-- single counter -->
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="single-counter text-center mt-40">
                        <span><span class="counter">163</span></span>
                        <p>SMK Negeri</p>
                    </div> <!-- single counter -->
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="single-counter text-center mt-40">
                        <span><span class="counter">961</span></span>
                        <p>SMA Swasta</p>
                    </div> <!-- single counter -->
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="single-counter text-center mt-40">
                        <span><span class="counter">910</span></span>
                        <p>SMK Swasta</p>
                    </div> <!-- single counter -->
                </div>
            </div> <!-- row -->
        </div> <!-- container -->
    </div>
    
    <!--====== COUNTER PART ENDS ======-->

    <!--====== PUBLICATION PART START ======-->

    <section id="publication-part" class="pt-115 pb-120 gray-bg bg_cover" style="background-image: url(assets/landing/images/publication/publication.png)">
        <div class="container">
            <div class="row align-items-end">
                <div class="col-lg-6 col-md-8 col-sm-7">
                    <div class="section-title pb-60">
                        <h5>Tim Kami</h5>
                        <h2>Tim Developer</h2>
                    </div> <!-- section title -->
                </div>
            </div> <!-- row -->
            <div class="row justify-content-center">
                <div class="col-lg-3 col-md-6 col-sm-8">
                    <div class="single-publication mt-30 text-center">
                        <div class="image">
                            <img src="{{ asset('assets/landing/images/team/pak_syaifur.jpg') }}" alt="Publication">
                        </div>
                        <div class="content pt-10">
                            <h5 class="book-title"><a href="#">Muhammad Syaifur Rohman</a></h5>
                            <p class="writer-name">Project Manager</p>
                        </div>
                        <div class="footer-about ml-40">
                            <ul class="mt-20">
                                <li><a href="https://www.linkedin.com/in/syaifur/"><i class="fa fa-linkedin"></i></a></li>
                                <li><a href="https://www.instagram.com/syeii/"><i class="fa fa-instagram"></i></a></li>
                            </ul>
                        </div>
                    </div> <!-- single publication -->
                </div>
                <div class="col-lg-3 col-md-6 col-sm-8">
                    <div class="single-publication mt-30 text-center">
                        <div class="image">
                            <img src="{{ asset('assets/landing/images/team/ekki.jpg') }}" alt="Publication">
                        </div>
                        <div class="content pt-10">
                            <h5 class="book-title"><a href="#">Ekki Taufik Maulana</a></h5>
                            <p class="writer-name">Fullstack Developer</p>
                        </div>
                        <div class="footer-about ml-40">
                            <ul class="mt-20">
                                <li><a href="https://www.linkedin.com/in/ekki-taufik-maulana-b32671204/"><i class="fa fa-linkedin"></i></a></li>
                                <li><a href="https://www.instagram.com/ekkitaufikm/"><i class="fa fa-instagram"></i></a></li>
                            </ul>
                        </div>
                    </div> <!-- single publication -->
                </div>
                <div class="col-lg-3 col-md-6 col-sm-8">
                    <div class="single-publication mt-30 text-center">
                        <div class="image">
                            <img src="{{ asset('assets/landing/images/team/labib.jpg') }}" alt="Publication">
                        </div>
                        <div class="content pt-10">
                            <h5 class="book-title"><a href="#">Labib Ahnaf Dhiyaul Khoir</a></h5>
                            <p class="writer-name">Fullstack Developer</p>
                        </div>
                        <div class="footer-about ml-40">
                            <ul class="mt-20">
                                <li><a href="https://www.linkedin.com/in/labib-ahnaf-aa674322a/"><i class="fa fa-linkedin"></i></a></li>
                                <li><a href="https://www.instagram.com/lbbahnf_/"><i class="fa fa-instagram"></i></a></li>
                            </ul>
                        </div>
                    </div> <!-- single publication -->
                </div>
            </div> <!-- row -->
        </div> <!-- container -->
    </section>

    <!--====== PUBLICATION PART ENDS ======-->

    

@endsection

@section('js-library')
{{-- Tempat Ngoding Meletakkan js library --}}
@endsection

@section('js-custom')
{{-- Tempat Ngoding Meletakkan js custom --}}
@endsection