@extends($auth)

@section('title')
 {{ $title }} - Login
@endsection

@push('css')
@endpush

@section('content')
    <section>
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-12">
                    <div class="login-card">
                        <form action="{{ url('login-proses') }}" method="POST" class="theme-form login-form">
                            @csrf
                            @method('POST')

                            <div class="row">
                                <img class="img-fluid px-5" src="{{asset('assets/images/logo/sibiling-new-logo.png')}}" alt="sibiling">
                            </div>

                            <h4>Login</h4>

                            @if (session()->has('sukses'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('sukses') }}
                                </div>
                            @elseif (session()->has('gagal'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('gagal') }}
                                </div>
                            @endif

                            <h6>Welcome back! Log in to your account.</h6>
                            <div class="form-group">
                                <label>NPSN/NIP</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i data-feather="user"></i></span>
                                    <input required class="form-control @error('username') is-invalid @enderror" type="text" id="username" name="username" placeholder="masukkan NPSM/NIP" />
                                    @error('username')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Password</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="icon-lock"></i></span>
                                    <input required class="form-control @error('login.password') is-invalid @enderror" type="password" name="login[password]" placeholder="*********" />
                                    <div class="show-hide"><span class="show"> </span></div>
                                    @error('login.password')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="captcha" class="col-md-3 col-form-label text-md-right">Captcha</label>
                                <div class="col-md-4 captcha">
                                    <span>{!! captcha_img() !!}</span>
                                </div>
                                <div class="col-md-5">
                                    <button type="button" class="btn btn-danger" class="reload" id="reload">
                                        &#x21bb;
                                    </button>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="input-group">
                                    <span class="input-group-text"><i class="icon-lock"></i></span>
                                    <input required id="captcha" type="text" class="form-control @error('captcha') is-invalid @enderror" placeholder="Masukkan Captcha" name="captcha">
                                    @error('captcha')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <button class="btn btn-primary btn-block" type="submit">Sign in</button>
                            </div>
                            <p>Belum punya akun ?<a class="ms-2" href="{{ url('register') }}">Daftar</a></p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
	
    @push('scripts')
    @endpush
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script type="text/javascript">
        $('#reload').click(function () {
            $.ajax({
                type: 'GET',
                url: 'reload-captcha',
                success: function (data) {
                    $(".captcha span").html(data.captcha);
                }
            });
        });
    </script>

@endsection