@extends($auth)

@section('title')
 {{ $title }} - Daftar
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    <section>
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-12">
                    <div class="login-card">
                        <form action="{{ url('register-proses') }}" method="POST" class="theme-form login-form" enctype="multipart/form-data">
                            @csrf
                            @method('POST')

                            <div class="row">
                                <img class="img-fluid px-5" src="{{asset('assets/images/logo/sibiling-new-logo.png')}}" alt="sibiling">
                            </div>

                            <h4>Register</h4>

                            @if (session()->has('sukses'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('sukses') }}
                                </div>
                            @elseif (session()->has('gagal'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('gagal') }}
                                </div>
                            @endif

                            <h6>Welcome, We are welcome you to sibiling !</h6>
                            <div class="form-group">
                                <label>Pilih Provinsi</label>
                                <div class="input-group">
                                    <select id="select-provinsi" class="form-select select2" name="idMProvinsi" aria-label="Default select example" required>
                                        <option value="">Pilihan Provinsi Sedang di Proses</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Pilih Daerah</label>
                                <div class="input-group">
                                    <select id="select-daerah" class="form-select select2" name="idMDaerah" aria-label="Default select example" required>
                                        <option value="">Pilih Provinsi Terlebih Dahulu</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Pilih Periode Sekolah</label>
                                <div class="input-group">
                                    <select id="select-periode" class="form-select select2" name="idPPeriode" aria-label="Default select example" required>
                                        <option value="">Pilih periode</option>
                                        @foreach ($periode as $r) 
                                            <option value="{{ $r->id }}">{{ $r->nama_periode }}</option>
                                        @endforeach
                                    </select >
                                </div>
                            </div>
                            <div class="form-group">
                                <label>NPSN</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i data-feather="user"></i></span>
                                    <input required class="form-control @error('npsn') is-invalid @enderror" type="number" name="npsn" placeholder="Masukkan NPSN Sekolah" value="{{old('npsn')}}" />
                                    @error('npsn')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Nama Sekolah</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i data-feather="user"></i></span>
                                    <input required class="form-control @error('nama') is-invalid @enderror" type="text" name="nama" placeholder="Masukkan Nama Sekolah" value="{{old('nama')}}" />
                                    @error('nama')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Nama Admin</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i data-feather="user"></i></span>
                                    <input required class="form-control @error('admin') is-invalid @enderror" type="text" name="admin" placeholder="Masukkan Nama Admin Sekolah" value="{{old('admin')}}" />
                                    @error('admin')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Nomor Whatsapp Admin</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i data-feather="user"></i></span>
                                    <input required class="form-control @error('nomor') is-invalid @enderror" type="number" name="nomor" placeholder="Masukkan Nomor Whatsapp Admin Sekolah" value="{{old('nomor')}}" />
                                    @error('nomor')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Upload Surat Pernyataan (PDF)</label> | <a href="{{ asset('word-template/surat-pernyataan-kepsek-sibiling.docx') }}">Template Surat</a>
                                <div class="input-group">
                                    <input required class="form-control @error('surat') is-invalid @enderror" type="file" name="surat" placeholder="Upload surat pernyataan" accept="application/pdf"/>
                                    @error('surat')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <button class="btn btn-primary btn-block" type="submit">Register</button>
                            </div>
                            <p>Sudah punya akun ?<a class="ms-2" href="{{ url('login') }}">Login</a></p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
	
    @push('scripts')
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script type="text/javascript">
            $(function() {
                    let baseUrl     = '{{ url('') }}';

                    $.getJSON(baseUrl+'/getAllProvinsi', (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih -</option>';
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                            });
                            $("#select-provinsi").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-provinsi").html(opt);
                        }
                        $("#select-provinsi").select2({
                            placeholder: "Pilih Provinsi",
                        });
                    });

                    $('#select-provinsi').on('change', function() {
                        var val1 = this.value;
                        $.getJSON(baseUrl+'/getProvinsiDaerah/'+val1, (result) => {
                            if (result.error_code == '0') {
                                let opt = '<option value="">- Pilih Daerah -</option>';
                                // var dataSem = result.data;
                                // dataSem.sort(function(a, b){
                                //     return a.id_semester - b.id_semester;
                                // });
                                $.each(result.data, function(i, item) {
                                    opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                                });
                                $("#select-daerah").html(opt);
                            }else{
                                let opt = '<option value="">- Tidak Bisa -</option>';
                                $("#select-daerah").html(opt);
                            }
                            $("#select-daerah").select2({
                                placeholder: "Pilih Daerah",
                            });
                        });
                    });

                $("#select-periode").select2({
                    placeholder: "Pilih Periode",
                });

            });

        </script>
    @endpush

@endsection