@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Users</h3>
        @endslot
        <li class="breadcrumb-item">Users</li>
        <li class="breadcrumb-item active">Edit</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url("admin/users/update") }}/{{ $user->id }}" method="post">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="form-group">
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Username</label>
                                    <input name="username" class="form-control" type="text" disabled value="{{ $user->username }}">
                                </div>
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Sekolah</label>
                                    <input name="idPSekolah" class="form-control" type="text" disabled value="{{ $user->sekolah->nama }}">
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Password</label>
                                    <input name="password" class="form-control" type="password" placeholder="Masukkan password">
                                    {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                                </div>
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Verifikasi Password</label>
                                    <input name="verifikasi" class="form-control" type="password" placeholder="Masukkan password">
                                    {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                                </div>
                            </div>
                                <div class="form-group mt-3">
                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection
