@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/store" method="POST">
                        @csrf            
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Waka Kurikulum</label>
                                {{-- <div class="col-sm-9"> --}}
                                    <select id="select-waka" class="form-select select2" name="idSGuru" aria-label="Default select example" required>
                                        <option value="">Pilih Waka Kurikulum</option>
                                        @foreach ($guru as $r) 
                                            <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                        @endforeach
                                    </select >
                                {{-- </div> --}}
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script>
            $("#select-waka").select2({
                placeholder: "Pilih Waka Kurikulum",
            });
        </script>
    @endpush

@endsection





