@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Tingkat</label>
                                <select id="select-kelas" class="form-select select2" name="idPKelas" aria-label="Default select example" required>
                                    <option value="">Pilih Jurusan Terlebih Dahulu</option>
                                </select >
                            </div>
                            <div class="table-responsive" id="tabel-jquery">
                                <table class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed" id="isi-tabel">
                                    <thead>
                                        <tr>
                                            <th width="50">No.</th>
                                            <th>Kelas</th>
                                            <th>NIP</th>
                                            <th>Nama</th>
                                            <th width="150">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalPilihWali" tabindex="-1" style="display: none;" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ganti / Set Wali Kelas</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="" method="post" id="formGantiWali">
                    @csrf
                    @method('PUT')
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Pilih Guru jadi Wali</label>
                            <select id="select-wali" class="form-select select2" name="idSGuru" aria-label="Default select example" required>
                                <option value="">Mohon Tunggu</option>
                            </select >
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script>
            $(function() {
                $("#isi-tabel").DataTable(); // tambahin ini ki

                let baseUrl     = '{{ url('') }}';
                let idSekolah = "{{ session()->get('idPSekolah') }}";
                let idPeriode = "{{ session()->get('idPPeriode') }}";
                
                let idAngkatan = 0;
                let idPKKode = 0;

                $('#tabel-jquery').hide();

                $.getJSON(baseUrl+'/getAngkatanKomplit/'+idSekolah, (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Kelas -</option>';
                        var dataSem = result.data;
                        dataSem.sort(function(a, b){
                            return a.nama - b.nama;
                        });
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-kelas").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-kelas").html(opt);
                    }
                    $("#select-kelas").select2({
                        placeholder: "Pilih Kelas",
                    });
                });

                $('#select-kelas').on('change', function() {
                    $("#isi-tabel").DataTable().clear().destroy(); // tambahin ini ki
                    
                    $('#tabel-jquery').show();
                    idAngkatan = $('#select-kelas').val();
                    
                    $("#isi-tabel").DataTable({
                    // $("#tabel-jquery")({
                        language: { // tambahin ini ki
                            emptyTable: "Tidak ada data Wali Kelas",
                            info: "Total: _TOTAL_ Data Siswa",
                            infoEmpty: "Menampilkan 0 dari 0 Data Wali Kelas",
                        },
                        responsive:  true,
                        autoWidth: false,
                        processing: true,
                        ajax: {
                            url: baseUrl+'/stakeholder/getTabelSekolahWali/' +idAngkatan,
                            method: 'GET',
                        },
                        dom: 'Bfrtip',
                        buttons: [
                            'copy', 'excel', 'pdf', 'colvis'
                        ]
                    });
                });

                $('#isi-tabel').on('click', '.set-wali', function() {
                    idPKKode = $(this).data("id") 

                    $.getJSON(baseUrl + '/' + '{{ $url }}' + '/get-non-wali', (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Wali -</option>';
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nip+' - '+item.nama+'</option>';
                            });
                            $("#select-wali").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-wali").html(opt);
                        }
                        $("#select-wali").select2({
                            placeholder: "Pilih Wali",
                        });
                    });
                    
                })

                $("#formGantiWali").on("submit", function(e) {
                    e.preventDefault(); // Mencegah submit form biasa

                    // Mengambil data dari form
                    var formData = $(this).serialize();
                    var actionUrl = baseUrl + '/' + '{{ $url }}' + '/update/' + idPKKode;
                    $('#formGantiWali').attr('action', actionUrl);

                    // Mengirim data ke server dengan AJAX
                    $.ajax({
                        url: $(this).attr('action'), // Ubah URL sesuai endpoint update wali
                        type: 'POST',
                        data: formData,
                        success: function(response) {
                            // Tanggapan sukses dari server
                            $("#isi-tabel").DataTable().clear().destroy(); // Menghapus dan menghancurkan tabel

                            $("#isi-tabel").DataTable({
                                language: {
                                    emptyTable: "Tidak ada data Wali Kelas",
                                    info: "Total: _TOTAL_ Data Siswa",
                                    infoEmpty: "Menampilkan 0 dari 0 Data Wali Kelas",
                                },
                                responsive: true,
                                autoWidth: false,
                                processing: true,
                                ajax: {
                                    url: baseUrl + '/stakeholder/getTabelSekolahWali/' + idAngkatan,
                                    method: 'GET',
                                },
                                dom: 'Bfrtip',
                                buttons: [
                                    'copy', 'excel', 'pdf', 'colvis'
                                ]
                            });

                            // Menampilkan pesan sukses atau tindakan lain yang diperlukan
                            alert("Data berhasil disimpan.");
                            $('#formGantiWali').closest('.modal').modal('hide');
                        },
                        error: function(xhr, status, error) {
                            // Tangani kesalahan
                            console.error(error);
                            alert("Terjadi kesalahan. Silakan coba lagi.");
                            $('#formGantiWali').closest('.modal').modal('hide');
                        }
                    });

                });
            });
        </script>
    @endpush

@endsection