@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                <tr>
                                    <td class="text-sm-end"><b>Nama Sekolah</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $guru->sekolah->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end">NIP</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $guru->nip }}</td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end">Nama</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ $guru->nama }}</td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end">Jumlah Siswa</td>
                                    <td>:</td>
                                    <td class="text-sm-start">{{ count($siswa) }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
    
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="display" id="basic-1">
                            <thead>
                                <tr>
                                    <th width="50">No.</th>
                                    <th>NISN</th>
                                    <th>Nama</th>
                                </tr>
                            </thead>
                            <tbody>
                                {{-- fitur di laravel --}}
                                @foreach ($siswa as $p)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        {{-- cara panggil kolom nama dari tabel daerah --}}
                                        <td>{{ $p->nisn }}</td>
                                        <td>{{ $p->nama }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    @push('scripts')
    @endpush

@endsection


