@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/store" method="POST">
                        @csrf                        
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">NIP</label>
                                <input name="nip" class="form-control @error('nip') is-invalid @enderror" type="number" placeholder="Masukkan NIP" value="{{ old('nip') }}" required>
                                @error('nip')
                                    <div class="invalid-feedback">
                                    {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Nama</label>
                                <input name="nama" class="form-control @error('nama') is-invalid @enderror" type="text" placeholder="Masukkan Nama" value="{{ old('nama') }}" required>
                                @error('nama')
                                    <div class="invalid-feedback">
                                    {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Nomor Telepon</label>
                                <input name="telp" class="form-control @error('telp') is-invalid @enderror" type="text" placeholder="Masukkan Nomor Telepon" value="{{ old('telp') }}">
                                @error('telp')
                                    <div class="invalid-feedback">
                                    {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Mata Pelajaran</label>
                                <select class="form-select select2 @error('idMapel') is-invalid @enderror" name="idMapel" aria-label="Default select example" required>
                                    <option value="">Pilih Mata Pelajaran</option>
                                    @foreach ($mapel as $r) 
                                        <option value="{{ $r->id }}" {{ old('idMapel') == $r->id ? 'selected' : '' }}>{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                                @error('idMapel')
                                    <div class="invalid-feedback">
                                    {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        $(function() {
            let baseUrl     = '{{ url('') }}';
            let idSekolah = "{{ session()->get('idPSekolah') }}";

            // $.getJSON(baseUrl+'/api/sekolah/getallsekolah', (result) => {
            //     if (result.error_code == '0') {
            //         let opt = '<option value="">- Pilih -</option>';
            //         $.each(result.data, function(i, item) {
            //             opt += '<option value="'+item.id+'">'+item.nama+'</option>';
            //         });
            //         $("#select-sekolah").html(opt);
            //     }else{
            //         let opt = '<option value="">- Tidak Bisa -</option>';
            //         $("#select-sekolah").html(opt);
            //     }
            //     $("#select-sekolah").select2({
            //         placeholder: "Pilih Sekolah",
            //     });
            // });

            
        });
    </script>
    @endpush

@endsection
