@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Siswa</h3>
        @endslot
        <li class="breadcrumb-item">Siswa</li>
        <li class="breadcrumb-item active">Detail</li>
    @endcomponent

    <div class="container-fluid pt-4">
                    
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                    <tr>
                                        <td class="text-sm-end">Nama Siswa</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $siswa->nama }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">NISN</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $siswa->nisn }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Kode Kelas</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $siswa->kelaskode->nama }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Agama</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $siswa->agama->nama ?? "Data tidak ditemukan" }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Tanggal Lahir</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $siswa->lahir_tanggal ?? "Data tidak ditemukan" }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Email</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $siswa->email ?? "Data tidak ditemukan" }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">No Telp</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $siswa->telp ?? "Data tidak ditemukan" }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Nama Orang Tua</td>
                                        <td>:</td>
                                        @if ($ortu == NULL)
                                            <td class="text-sm-start">Data tidak ditemukan</td>
                                        @else
                                            <td class="text-sm-start">{{ $ortu->nama ?? 'Ortu Belum Ada' }} <a href="{{ url("admin/siswa/ortu/" . $siswa->id, []) }}" ><i class="fa fa-info-circle"></i></a></td>
                                        @endif
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Nama Wali Kelas</td>
                                        <td>:</td>                          
                                        <td class="text-sm-start">{{ $sekolah_wali ? $sekolah_wali->guru->nama : 'Wali Kelas Belum Ada' }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Nip/Niy Wali Kelas</td>
                                        <td>:</td>                          
                                        <td class="text-sm-start">{{ $sekolah_wali ? $sekolah_wali->guru->nip : 'Wali Kelas Belum Ada' }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Nama Guru Konseling</td>
                                        <td>:</td>                          
                                        {{-- <td class="text-sm-start">{{ $konselor ? $konselor->guru->nama : 'Konselor Belum Ada' }}</td> --}}
                                        <td class="text-sm-start">{{ $konselor->guru->nama ?? 'Guru Konseling Belum Ada' }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center" colspan="4">
                                            <form action="{{ url($url)}}/delete/{{ $id }}" method="post">
                                                @method('delete')
                                                @csrf
                                                <button class="btn btn-danger float-end" onclick="return confirm('Apakah Anda Yakin Hapus {{ $siswa->nisn }}-{{ $siswa->nama }} ?')">Hapus Siswa</button>
                                            </form>
                                            <a href="{{ url($url) }}/{{ $siswa->id }}/edit"><button type='button' class='btn btn-primary float-end'>Edit</button></a>
                                        </td>
                                    </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">Mutasi Kelas Siswa</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive" id="tabel-jquery">
                            <table class="table text-center">
                                <thead >
                                    <tr>
                                        <th>Periode</th>
                                        <th>Kelas</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($siswaMutasi as $sm)
                                    <tr>
                                        <td>{{ $sm->periode->nama_periode }}</td>
                                        <td>{{ $sm->kelaskode->kelas->nama }} {{ $sm->kelaskode->kelas->jurusan->nama }} {{ $sm->kelaskode->nama }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    

    @push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>

    @endpush

@endsection
