@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Siswa</h3>
        @endslot
        <li class="breadcrumb-item">Siswa</li>
        <li class="breadcrumb-item active">Tambah</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <form action="{{ url($url) }}/store" method="POST">
                @csrf
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-lg-6">
                                    <h5 class="card-title">{{ $page }}</h5>
                                </div>
                                <div class="col-lg-6">
                                    <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            @if (session()->get('role') == 1)
                                <div class="mb-3">
                                    <label class="col-sm-3 col-form-label">Pilih Provinsi</label>
                                    <select id="select-provinsi" class="form-select select2" name="idMProvinsi" aria-label="Default select example" required>
                                        <option value="">Pilihan Provinsi Sedang di Proses</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="col-sm-3 col-form-label">Pilih Daerah</label>
                                    <select id="select-daerah" class="form-select select2" name="idMDaerah" aria-label="Default select example" required>
                                        <option value="">Pilih Provinsi Terlebih Dahulu</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="col-sm-3 col-form-label">Pilih Sekolah</label>
                                    <select id="select-sekolah" class="form-select select2" name="idPSekolah" aria-label="Default select example" required>
                                        <option value="">Pilih Daerah Terlebih Dahulu</option>
                                    </select>
                                </div>
                            @elseif (session()->get('role') == 2)
                                <input type="hidden" name="idPSekolah" value="{{ session()->get('idPSekolah') }}">
                            @endif
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Kelas</label>
                                <select id="select-kodekelas" class="form-select select2" name="idPKKode" aria-label="Default select example" required>
                                    <option value="">Pilih Kelas Terlebih Dahulu</option>
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Guru Konseling</label>
                                <select id="select-sem" class="form-select select2" name="idSKonselor" aria-label="Default select example" required>
                                    <option value="">Pilih Guru Konseling</option>
                                    @foreach ($konselor as $r) 
                                        <option value="{{ $r->id }}">{{ $r->guru->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Agama</label>
                                <select id="select-sem" class="form-select select2" name="idMAgama" aria-label="Default select example" required>
                                    <option value="">Pilih Agama</option>
                                    @foreach ($agama as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">NISN</label>
                                <input name="nisn" class="form-control" type="text" placeholder="masukkan nisn" required>
                                {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Nama</label>
                                <input name="nama" class="form-control" type="text" placeholder="Masukkan Nama" required>
                                {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal Lahir</label>
                                <input name="lahir_tanggal" class="form-control datetimepicker-input digits" type="date" required>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tempat Lahir</label>
                                <input name="lahir_tempat" class="form-control" type="text" placeholder="Masukkan Tempat Lahir" required>
                                {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Email</label>
                                <input name="email" class="form-control" type="email" placeholder="masukkan email">
                                {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">No Telp</label>
                                <input name="telp" class="form-control" type="text" placeholder="masukkan nomor telp" required>
                                {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Tempat Tinggal</label>
                                <select id="select-sem" class="form-select select2" name="idMTempat" aria-label="Default select example" required>
                                    <option value="">Pilih Tempat Tinggal</option>
                                    @foreach ($tempat as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Data Orang Tua</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Nama</label>
                                <input name="namaOrtu" class="form-control" type="text" placeholder="Masukkan Nama" required>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Alamat</label>
                                <input name="alamatOrtu" class="form-control" type="text" placeholder="Masukkan Alamat" required>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Pekerjaan</label>
                                <select id="select-kodekelas" class="form-select select2" name="idMPekerjaan" aria-label="Default select example" required>
                                    <option value="">Pilih Pekerjaan</option>
                                    @foreach ($pekerjaan as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script>
            $("#isi-tabel").DataTable(); // tambahin ini ki

            let baseUrl     = '{{ url('') }}';
            $('#tabel-jquery').hide();
        </script>
        {{-- @include('admin.filter.perpus')
        @include('admin.filter.jurusan')
        @include('admin.filter.angkatan')
        @include('admin.filter.kelas') --}}

        @if (session()->get('role') == 1)
            <script>
                $.getJSON(baseUrl+'/getAllProvinsi', (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih -</option>';
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-provinsi").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-provinsi").html(opt);
                    }
                    $("#select-provinsi").select2({
                        placeholder: "Pilih Provinsi",
                    });
                });

                $('#select-provinsi').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/getProvinsiDaerah/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Daerah -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                            });
                            $("#select-daerah").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-daerah").html(opt);
                        }
                        $("#select-daerah").select2({
                            placeholder: "Pilih Daerah",
                        });
                    });
                });

                $('#select-daerah').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/getDaerahSekolah/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Sekolah -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                            });
                            $("#select-sekolah").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-sekolah").html(opt);
                        }
                        $("#select-sekolah").select2({
                            placeholder: "Pilih Sekolah",
                        });
                    });
                });

                $('#select-sekolah').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/getKelasKomplit/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Kelas -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                            });
                            $("#select-kodekelas").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-kodekelas").html(opt);
                        }
                        $("#select-kodekelas").select2({
                            placeholder: "Pilih Kelas",
                        });
                    });
                });
            </script>
        @else

            @include('admin.filter.kelaskomplit')
            @include('admin.filter.siswaKonselorKelas')
        @endif
        
    @endpush

@endsection
