@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Orang Tua</h3>
        @endslot
        <li class="breadcrumb-item">Orang Tua</li>
        <li class="breadcrumb-item active">Detail</li>
    @endcomponent
    
    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url2) }}/{{ $id }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                    <tr>
                                        <td class="text-sm-end">Nama Siswa</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $ortu->siswa->nama }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Nama Ortu</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $ortu->nama }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Pekerjaan</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $ortu->pekerjaan->nama ?? '-' }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Alamat</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $ortu->alamat }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end">Telpon</td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $ortu->telp ?? '-' }}</td>
                                    </tr>
                                    <tr>
                                        <tr>
                                            <td class="text-center" colspan="3">
                                                <a href="{{ url($url) }}/{{ $ortu->id }}/edit"><button type='button' class='btn btn-primary'>Edit</button></a>
                                            </td>
                                        </tr>
                                    </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>

    @endpush

@endsection
