@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Orang Tua</h3>
        @endslot
        <li class="breadcrumb-item">Orang Tua</li>
        <li class="breadcrumb-item active">Edit</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url)}}/update/{{ $ortu->id }}" method="post">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="form-group">
                                <label class="col-sm-3 col-form-label">Pekerjaan</label>
                                <select id="select-sem" class="form-select select2" name="idMPekerjaan" aria-label="Default select example">
                                    <option value="">Silahkan Pilih Pekerjaan Orang Tua</option>
                                    @foreach ($pekerjaan as $r) 
                                        <option value="{{ $r->id }}" {{ $r->id == $ortu->idMPekerjaan ? 'selected' : '' }}>{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="form-group">
                                <label>Nama Ortu</label>
                                <input type="text" id="i-nama" class="form-control" name="nama" placeholder="Nama Ortu" value="{{ $ortu->nama }}">
                            </div>
                            <div class="form-group">
                                <label>Alamat</label>
                                <input type="text" id="i-nama" class="form-control" name="alamat" placeholder="Alamat Ortu" value="{{ $ortu->alamat }}">
                            </div>
                            <div class="form-group">
                                <label>Telepon</label>
                                <input type="number" id="i-nama" class="form-control" name="telp" placeholder="Telepon Ortu" value="{{ $ortu->telp }}">
                            </div>
                            <div class="form-group mt-3">
                                <button type="submit" class="btn btn-primary">Simpan</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    @endpush

@endsection
