@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Orang Tua</h3>
        @endslot
        <li class="breadcrumb-item">Siswa</li>
        <li class="breadcrumb-item">Orang Tua</li>
        <li class="breadcrumb-item active">Tambah</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/store" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Siswa</label>
                                <select id="select-sem" class="form-select select2" name="idSiswa" aria-label="Default select example" required>
                                    <option value="">Pilih Siswa</option>
                                    @foreach ($siswa as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Pekerjaan</label>
                                <select id="select-sem" class="form-select select2" name="idMPekerjaan" aria-label="Default select example" required>
                                    <option value="">Pilih Pekerjaan</option>
                                    @foreach ($pekerjaan as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Nama</label>
                                <input name="nama" class="form-control" type="text" placeholder="Masukkan Nama">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Alamat</label>
                                <input name="alamat" class="form-control" type="text" placeholder="Masukkan Alamat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Telepon</label>
                                <input name="telp" class="form-control" type="number" placeholder="Masukkan Telepon">
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    @endpush

@endsection
