@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Sekolah</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Sekolah</li>
        <li class="breadcrumb-item active">Detail</li>
    @endcomponent

    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                    <tr>
                                        <td class="text-sm-end"><b>Nama Sekolah</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $perpus_sekolah->nama }}</b></td>
                                    </tr>
                                    @foreach ($perpus_sekolah->jurusan as $p)
                                    
                                    <tr>
                                        <td class="text-sm-end"><b>Jurusan</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start">{{ $p->nama }} <a href="{{ url($url2. "/". $p->id, []) }}" ><i class="fa fa-info-circle"></i></a></td>
                                    </tr>
                                    @endforeach

                                    <tr>
                                        <td class="text-sm-end"><b>Kop Surat</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $perpus_sekolah->logo }}</b></td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end"><b>Telfon Sekolah</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $perpus_sekolah->telp }}</b></td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end"><b>Alamat Website Sekolah</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $perpus_sekolah->web }}</b></td>
                                    </tr>
                                    <tr>
                                        <td class="text-sm-end"><b>Alamat Email Sekolah</b></td>
                                        <td>:</td>
                                        <td class="text-sm-start"><b>{{ $perpus_sekolah->email }}</b></td>
                                    </tr>
                            </tbody>
                        </table>  
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
@endpush

@endsection
