@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Sekolah</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Sekolah</li>
        <li class="breadcrumb-item active">Edit</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url("$url") }}/update/{{ $perpus_sekolah->id }}" method="post">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="form-group">
                                <label class="col-sm-3 col-form-label">Daerah</label>
                                    <select id="select-sem" class="form-select select2" name="idMDaerah" aria-label="Default select example" disabled>
                                        <option value="{{ $perpus_sekolah->idMDaerah }}">{{ $perpus_sekolah->daerah->nama }}</option>
                                    </select >
                            </div>
                            <div class="form-group">
                                <label>Nama Sekolah</label>
                                <input type="text" id="i-nama" class="form-control" name="nama" placeholder="Pekerjaan" value="{{ $perpus_sekolah->nama }}" disabled>
                            </div>
                            <div class="form-group">
                                <label>Alamat</label>
                                <input type="text" id="i-nama" class="form-control" name="alamat" placeholder="Pekerjaan" value="{{ $perpus_sekolah->alamat }}" disabled>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Kop Surat</label>
                                <input name="logo" class="form-control" type="text" placeholder="Kop Surat Sekolah" value="{{ $perpus_sekolah->logo ?? '' }}" disabled>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Logo</label>
                                <input name="logo_gambar" class="form-control" type="text" placeholder="Logo Sekolah" value="{{ $perpus_sekolah->logo_gambar ?? '' }}" disabled>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Telpon Sekolah</label>
                                <input name="telp" class="form-control" type="text" placeholder="Telpon Sekolah" value="{{ $perpus_sekolah->telp ?? '' }}">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Alamat Website Sekolah</label>
                                <input name="web" class="form-control" type="text" placeholder="Alamat Website Sekolah" value="{{ $perpus_sekolah->web ?? '' }}">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Alamat Email Sekolah</label>
                                <input name="email" class="form-control" type="email" placeholder="Alamat Email Sekolah" value="{{ $perpus_sekolah->email ?? '' }}">
                            </div>
                            <div class="form-group mt-3">
                                <button type="submit" class="btn btn-primary">Simpan</button>
                                <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection
