@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Sekolah</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Sekolah</li>
        <li class="breadcrumb-item active">Tambah</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/store" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Provinsi</label>
                                <select id="select-provinsi" class="form-select select2" name="idMProvinsi" aria-label="Default select example" required>
                                    <option value="">Pilihan Provinsi Sedang di Proses</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Daerah</label>
                                <select id="select-daerah" class="form-select select2" name="idMDaerah" aria-label="Default select example" required>
                                    <option value="">Pilih Provinsi Terlebih Dahulu</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Periode</label>
                                <select id="select-periode" class="form-select select2" name="idPPeriode" aria-label="Default select example" required>
                                    <option value="">Pilih periode</option>
                                    @foreach ($periode as $r) 
                                        <option value="{{ $r->id }}">{{ $r->nama_periode }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">NPSN Sekolah</label>
                                <input name="npsn" class="form-control" type="text" placeholder="NPSN Sekolah" required>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Nama Sekolah</label>
                                <input name="nama" class="form-control" type="text" placeholder="Nama Sekolah" required>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Alamat Sekolah</label>
                                <input name="alamat" class="form-control" type="text" placeholder="Alamat Sekolah">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Kop Surat</label><br>
                                <input class="form-control" type="file" name="photo"> 
                                {{-- <input name="logo" class="form-control" type="text" placeholder="Logo Sekolah"> --}}
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Logo Sekolah</label><br>
                                <input class="form-control" type="file" name="gambar"> 
                                {{-- <input name="logo" class="form-control" type="text" placeholder="Logo Sekolah"> --}}
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Telpon Sekolah</label>
                                <input name="telp" class="form-control" type="text" placeholder="Telpon Sekolah">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Alamat Website Sekolah</label>
                                <input name="web" class="form-control" type="text" placeholder="Alamat Website Sekolah">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Alamat Email Sekolah</label>
                                <input name="email" class="form-control" type="email" placeholder="Alamat Email Sekolah">
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script>
        $(function() {
            let baseUrl     = '{{ url('') }}';

            $.getJSON(baseUrl+'/getAllProvinsi', (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih -</option>';
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                    });
                    $("#select-provinsi").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-provinsi").html(opt);
                }
                $("#select-provinsi").select2({
                    placeholder: "Pilih Provinsi",
                });
            });

            $('#select-provinsi').on('change', function() {
                var val1 = this.value;
                $.getJSON(baseUrl+'/getProvinsiDaerah/'+val1, (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Daerah -</option>';
                        // var dataSem = result.data;
                        // dataSem.sort(function(a, b){
                        //     return a.id_semester - b.id_semester;
                        // });
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-daerah").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-daerah").html(opt);
                    }
                    $("#select-daerah").select2({
                        placeholder: "Pilih Daerah",
                    });
                });
            });

            $('#select-daerah').on('change', function() {
                var val1 = this.value;
                $.getJSON(baseUrl+'/getDaerahSekolah/'+val1, (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Sekolah -</option>';
                        // var dataSem = result.data;
                        // dataSem.sort(function(a, b){
                        //     return a.id_semester - b.id_semester;
                        // });
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-sekolah").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-sekolah").html(opt);
                    }
                    $("#select-sekolah").select2({
                        placeholder: "Pilih Sekolah",
                    });
                });
            });

            $('#select-sekolah').on('change', function() {
                var val1 = this.value;
                $.getJSON(baseUrl+'/getjurusansekolah/'+val1, (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Jurusan -</option>';
                        // var dataSem = result.data;
                        // dataSem.sort(function(a, b){
                        //     return a.id_semester - b.id_semester;
                        // });
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-jurusan").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-jurusan").html(opt);
                    }
                    $("#select-jurusan").select2({
                        placeholder: "Pilih Jurusan",
                    });
                });
            });

            $("#select-periode").select2({
                placeholder: "Pilih Periode",
            });

        });
    </script>
    @endpush

@endsection
