@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Kelas</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Indeks Kelas</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}/create" class="btn btn-sm btn-primary float-end">Tambah Indeks Kelas</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        @if (session()->get('role') == 1)
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Provinsi</label>
                                <select id="select-provinsi" class="form-select select2" name="idMProvinsi" aria-label="Default select example" required>
                                    <option value="">Pilihan Provinsi Sedang di Proses</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Daerah</label>
                                <select id="select-daerah" class="form-select select2" name="idMDaerah" aria-label="Default select example" required>
                                    <option value="">Pilih Provinsi Terlebih Dahulu</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Sekolah</label>
                                <select id="select-sekolah" class="form-select select2" name="idPSekolah" aria-label="Default select example" required>
                                    <option value="">Pilih Daerah Terlebih Dahulu</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Jurusan</label>
                                <select id="select-jurusan" class="form-select select2" name="idPJurusan" aria-label="Default select example" required>
                                    <option value="">Pilih Sekolah Terlebih Dahulu</option>
                                </select>
                            </div>
                        @endif
                        <div class="mb-3">
                            <label class="col-sm-3 col-form-label">Pilih Kelas</label>
                            <select id="select-kelas" class="form-select select2" name="idPKelas" aria-label="Default select example" required>
                                <option value="">Pilih Jurusan Terlebih Dahulu</option>
                            </select >
                        </div>
                        <div class="table-responsive" id="tabel-jquery">
                            <table id="isi-tabel" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed">
                                <thead>
                                    <tr>
                                        <th width="50">No.</th>
                                        @if (session()->get('role') == 1)
                                            <th>Nama Sekolah</th>    
                                        @endif
                                        <th>Kelas</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {{-- fitur di laravel --}}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script>
        $("#isi-tabel").DataTable(); // tambahin ini ki

        let baseUrl     = '{{ url('') }}';
        $('#tabel-jquery').hide();
    </script>
    @include('admin.filter.perpus')
    <script>

        @if (session()->get('role') == 1)
            $.getJSON(baseUrl+'/getJurusanSekolah/'+"{{ session()->get('idPSekolah') }}", (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih Jurusan -</option>';
                    // var dataSem = result.data;
                    // dataSem.sort(function(a, b){
                    //     return a.id_semester - b.id_semester;
                    // });
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                    });
                    $("#select-jurusan").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-jurusan").html(opt);
                }
                $("#select-jurusan").select2({
                    placeholder: "Pilih Jurusan",
                });
            });

            $('#select-jurusan').on('change', function() {
                var val1 = this.value;
                $.getJSON(baseUrl+'/getAngkatanSekolah/'+val1, (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Kelas -</option>';
                        // var dataSem = result.data;
                        // dataSem.sort(function(a, b){
                        //     return a.id_semester - b.id_semester;
                        // });
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-kelas").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-kelas").html(opt);
                    }
                    $("#select-kelas").select2({
                        placeholder: "Pilih Kelas",
                    });
                });
            });
        @endif
        
        @if (session()->get('role') == 2)
        
            let idSekolah = "{{ session()->get('idPSekolah') }}";
            $.getJSON(baseUrl+'/getAngkatanKomplit/'+idSekolah, (result) => {
                if (result.error_code == '0') {
                    let opt = '<option value="">- Pilih Kelas -</option>';
                    var dataSem = result.data;
                    dataSem.sort(function(a, b){
                        return a.nama - b.nama;
                    });
                    $.each(result.data, function(i, item) {
                        opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                    });
                    $("#select-kelas").html(opt);
                }else{
                    let opt = '<option value="">- Tidak Bisa -</option>';
                    $("#select-kelas").html(opt);
                }
                $("#select-kelas").select2({
                    placeholder: "Pilih Kelas",
                });
            });
        @endif

            $('#select-kelas').on('change', function() {
                $("#isi-tabel").DataTable().clear().destroy(); // tambahin ini ki
                
                $('#tabel-jquery').show();
                var idPKelas = $('#select-kelas').val();
                // console.log(idPKKode);
                // var val3 = this.value;
                
                $("#isi-tabel").DataTable({
                // $("#tabel-jquery")({
                    language: { // tambahin ini ki
                        emptyTable: "Tidak ada data Kelas",
                        info: "Total: _TOTAL_ Data Kelas",
                        infoEmpty: "Menampilkan 0 dari 0 Data Kelas",
                    },
                    responsive:  true,
                    autoWidth: false,
                    processing: true,
                    ajax: {
                        url: baseUrl+'/perpus/getTabelSekolahKelas/' +idPKelas,
                        method: 'GET',
                    },
                    dom: 'Bfrtip',
                    buttons: [
                        'copy', 'excel', 'pdf', 'colvis'
                    ]
                });
            });
    </script>
    @endpush

@endsection
