@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Tingkat</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Tingkat</li>
        <li class="breadcrumb-item active">Edit</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url("$url")}}/update/{{ $id }}" method="post">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <input type="hidden" id="i-nama" class="form-control" name="id" placeholder="" value="{{ $perpus_kelas->id }}">
                            <div class="form-group">
                                <label>Tingkat</label>
                                <input type="text" id="i-nama" class="form-control" name="nama" placeholder="Tingkat" value="{{ $perpus_kelas->nama }}">
                            </div>
                            <div class="form-group mt-3">
                                <button type="submit" class="btn btn-primary">Simpan</button>
                                <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection
