@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Tingkat</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Tingkat</li>
        <li class="breadcrumb-item active">Tambah</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/store" method="POST">
                        @csrf
                        <div class="card-body">
                            @if (session()->get('role') == 1)
                                <div class="mb-3">
                                    <label class="col-sm-3 col-form-label">Pilih Provinsi</label>
                                    <select id="select-provinsi" class="form-select select2" name="idMProvinsi" aria-label="Default select example" required>
                                        <option value="">Pilihan Provinsi Sedang di Proses</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="col-sm-3 col-form-label">Pilih Daerah</label>
                                    <select id="select-daerah" class="form-select select2" name="idMDaerah" aria-label="Default select example" required>
                                        <option value="">Pilih Provinsi Terlebih Dahulu</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="col-sm-3 col-form-label">Pilih Sekolah</label>
                                    <select id="select-sekolah" class="form-select select2" name="idPSekolah" aria-label="Default select example" required>
                                        <option value="">Pilih Daerah Terlebih Dahulu</option>
                                    </select >
                                </div>
                            @elseif (session()->get('role') == 2)
                                <input type="hidden" name="idPSekolah" value="{{ session()->get('idPSekolah') }}">
                            @endif
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Jurusan</label>
                                <select id="select-jurusan" class="form-select select2" name="idPJurusan" aria-label="Default select example" required>
                                    <option value="">Pilih Sekolah Terlebih Dahulu</option>
                                </select >
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tingkat</label>
                                <input name="nama" class="form-control" type="text" placeholder="Isi Tingkat">
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
    <script>
        $(function() {
            let baseUrl     = '{{ url('') }}';

            @if (session()->get('role') == 1)
                $.getJSON(baseUrl+'/getAllProvinsi', (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih -</option>';
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-provinsi").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-provinsi").html(opt);
                    }
                    $("#select-provinsi").select2({
                        placeholder: "Pilih Provinsi",
                    });
                });

                $('#select-provinsi').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/getProvinsiDaerah/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Daerah -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                            });
                            $("#select-daerah").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-daerah").html(opt);
                        }
                        $("#select-daerah").select2({
                            placeholder: "Pilih Daerah",
                        });
                    });
                });

                $('#select-daerah').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/getDaerahSekolah/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Sekolah -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                            });
                            $("#select-sekolah").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-sekolah").html(opt);
                        }
                        $("#select-sekolah").select2({
                            placeholder: "Pilih Sekolah",
                        });
                    });
                });

                $('#select-sekolah').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/getJurusanSekolah/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Jurusan -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                            });
                            $("#select-jurusan").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-jurusan").html(opt);
                        }
                        $("#select-jurusan").select2({
                            placeholder: "Pilih Jurusan",
                        });
                    });
                });

                $('#select-jurusan').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/getKelasSekolah/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Kelas -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                            });
                            $("#select-kelas").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-kelas").html(opt);
                        }
                        $("#select-kelas").select2({
                            placeholder: "Pilih Kelas",
                        });
                    });
                });
            
            @elseif(session()->get('role') == 2)

                $.getJSON(baseUrl+'/getJurusanSekolah/'+'{{ session()->get('idPSekolah') }}', (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Jurusan -</option>';
                        // var dataSem = result.data;
                        // dataSem.sort(function(a, b){
                        //     return a.id_semester - b.id_semester;
                        // });
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-jurusan").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-jurusan").html(opt);
                    }
                    $("#select-jurusan").select2({
                        placeholder: "Pilih Jurusan",
                    });
                });

            @endif

        });
    </script>
    @endpush

@endsection
