@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Informasi Sekolah</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item active">Sekolah</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="row justify-content-center">
                    <div class="col-lg-10 col-sm-12">
                        <div class="card border-top border-0 border-4 border-info">
                            <div class="card-header p-3">
                                <div class="row">
                                    <div class="col-lg-6">
                                        {{-- Kalo di laravel, ada fitur kurung kurawal 2 kali untuk echo --}}
                                        <h5 class="card-title">{{ $page }} {{ $sekolahan->nama }}</h5>
                                    </div>
                                    <div class="col-lg-6">
                                        {{-- karena pake route web resource, dibuat sama semua urlnya. Ini otomatis ke halaman form --}}
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <table id="datatable" class="table text-center">
                                    <tbody>
                                        <tr>
                                            <td class="text-sm-end"><b>Sekolah</b></td>
                                            <td>:</td>
                                            <td class="text-sm-start"><b> {{ $sekolahan->nama }} </b></td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Daerah</td>
                                            <td>:</td>
                                            <td class="text-sm-start">{{ $sekolahan->daerah->nama }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Provinsi</td>
                                            <td>:</td>
                                            <td class="text-sm-start">{{ $sekolahan->daerah->provinsi->nama }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Alamat</td>
                                            <td>:</td>
                                            <td class="text-sm-start">{{ $sekolahan->alamat }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Telp</td>
                                            <td>:</td>
                                            <td class="text-sm-start">{{ $sekolahan->telp }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Website</td>
                                            <td>:</td>
                                            <td class="text-sm-start">{{ $sekolahan->web }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Email</td>
                                            <td>:</td>
                                            <td class="text-sm-start">{{ $sekolahan->email }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Logo Sekolah</td>
                                            <td>:</td>
                                            @if ($sekolahan->logo_gambar == Null)
                                                <td class="text-sm-start">logo sekolah belum ada</td>
                                            @else
                                                <td>
                                                    <img class="img-90" src="{{ url("upload\logo_gambar") }}\{{ $sekolahan->logo_gambar }}" alt="" align="left">
                                                </td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end">Kop Surat</td>
                                            <td>:</td>
                                            @if ($sekolahan->logo == Null)
                                                <td>Kop Surat belum ada</td>
                                            @else
                                                <td>
                                                    <img width="500" src="{{ url("upload\logo_sekolah") }}\{{ $sekolahan->logo }}" alt="" align="left">
                                                </td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td class="text-sm-end"></td>
                                            <td><a href="{{ url($url)}}/{{ $sekolahan->id }}/edit" class="btn btn-primary">Edit</a></td>
                                            <td class="text-sm-start"></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    @endpush

@endsection